/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.api.data.variants;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.tocraft.craftedcore.data.SynchronizedJsonReloadListener;
import dev.tocraft.craftedcore.platform.PlatformData;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.variant.NBTTypeProvider;
import dev.tocraft.walkers.api.variant.RegistryTypeProvider;
import dev.tocraft.walkers.api.variant.TypeProvider;
import dev.tocraft.walkers.api.variant.TypeProviderRegistry;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeProviderDataManager
extends SynchronizedJsonReloadListener {
    public static final Gson GSON = new GsonBuilder().create();
    public static final Codec<TypeProviderEntry> TYPE_PROVIDER_LIST_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("entity_type").forGetter(TypeProviderEntry::entityTypeKey), (App)Codec.STRING.optionalFieldOf("required_mod", (Object)"").forGetter(o -> {
        String requiredMod = o.requiredMod();
        if (requiredMod == null) {
            return "";
        }
        return requiredMod;
    }), (App)Codec.either(NBTTypeProvider.CODEC, RegistryTypeProvider.CODEC).fieldOf("type_provider").forGetter(o -> o.providerEither)).apply((Applicative)instance, instance.stable(TypeProviderEntry::new)));

    public TypeProviderDataManager() {
        super(GSON, "walkers/variants");
    }

    protected void onApply(@NotNull Map<ResourceLocation, JsonElement> map) {
        TypeProviderRegistry.clearAll();
        TypeProviderRegistry.registerDefault();
        for (Map.Entry<ResourceLocation, JsonElement> mapEntry : map.entrySet()) {
            TypeProviderEntry typeProviderEntry = TypeProviderDataManager.typeProviderFromJson(mapEntry.getValue().getAsJsonObject());
            EntityType<?> entityType = typeProviderEntry.entityType();
            if (entityType == null) continue;
            TypeProviderRegistry.register(entityType, typeProviderEntry.typeProvider());
            Walkers.LOGGER.debug("{}: {} registered", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)typeProviderEntry.entityTypeKey());
        }
    }

    private static TypeProviderEntry typeProviderFromJson(JsonObject json) {
        return (TypeProviderEntry)TYPE_PROVIDER_LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(JsonParseException::new);
    }

    public record TypeProviderEntry(ResourceLocation entityTypeKey, @Nullable String requiredMod, Either<NBTTypeProvider<?>, RegistryTypeProvider<?, ?>> providerEither) {
        public TypeProviderEntry(EntityType<?> entityType, String requiredMod, NBTTypeProvider<?> typeProvider) {
            this(EntityType.getKey(entityType), requiredMod, Either.left(typeProvider));
        }

        @Nullable
        public EntityType<?> entityType() {
            if ((this.requiredMod() == null || this.requiredMod().isBlank() || PlatformData.isModLoaded((String)this.requiredMod())) && BuiltInRegistries.ENTITY_TYPE.containsKey(this.entityTypeKey())) {
                return (EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(this.entityTypeKey()).orElseThrow()).value();
            }
            return null;
        }

        public TypeProvider<?> typeProvider() {
            return (TypeProvider)this.providerEither.map(n -> n, t -> t);
        }
    }
}

