/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.api.model.impl;

import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.model.ClassArmProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class GenericEntityArm<L extends LivingEntity, R extends LivingEntityRenderState, T extends EntityModel<R>>
implements ClassArmProvider<T> {
    @Nullable
    private final ModelLayerLocation modelLayerLocation;
    @NotNull
    private final String[] modelParts;
    private boolean failed = false;

    public GenericEntityArm() {
        this((ModelLayerLocation)null, "right_front_leg");
    }

    public GenericEntityArm(@NotNull ModelLayerLocation modelLayerLocation) {
        this(modelLayerLocation, "right_front_leg");
    }

    public GenericEntityArm(String ... modelParts) {
        this((ModelLayerLocation)null, modelParts);
    }

    public GenericEntityArm(@Nullable ModelLayerLocation modelLayerLocation, String ... modelParts) {
        this.modelLayerLocation = modelLayerLocation;
        this.modelParts = modelParts;
    }

    @Override
    @Nullable
    public ModelPart getArm(LivingEntity entity, T model) {
        ModelLayerLocation modelLayer = this.modelLayerLocation != null ? this.modelLayerLocation : new ModelLayerLocation(EntityType.getKey((EntityType)entity.getType()), "main");
        try {
            ModelPart modelPart = Minecraft.getInstance().getEntityModels().bakeLayer(modelLayer);
            for (String part : this.modelParts) {
                modelPart = modelPart.getChild(part);
            }
            return modelPart;
        }
        catch (Exception e) {
            if (!this.failed) {
                Walkers.LOGGER.error("{}: Caught an error rendering the arm for the {}.", new Object[]{GenericEntityArm.class.getSimpleName(), EntityType.getKey((EntityType)entity.getType()), e});
                this.failed = true;
            }
            return null;
        }
    }
}

