/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.api.platform;

import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnlockHandler {
    @Nullable
    private static LivingEntity getTargetedLivingEntity(@NotNull ServerPlayer player, double maxDistance) {
        Entity entity2;
        Predicate<Entity> entityFilter;
        AABB searchBox;
        Vec3 eyePos = player.getEyePosition();
        Vec3 lookVec = player.getLookAngle();
        Vec3 endPos = eyePos.add(lookVec.x * maxDistance, lookVec.y * maxDistance, lookVec.z * maxDistance);
        BlockHitResult blockHit = player.level().clip(new ClipContext(eyePos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        endPos = blockHit.getLocation();
        EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)eyePos, (Vec3)endPos, (AABB)(searchBox = player.getBoundingBox().expandTowards(lookVec.scale(maxDistance)).inflate(1.0)), entityFilter = entity -> entity instanceof LivingEntity && !entity.isSpectator() && entity.isAlive(), (double)maxDistance);
        if (entityHit != null && (entity2 = entityHit.getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity2;
            return livingEntity;
        }
        return null;
    }
}

