/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.api.variant;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.variant.TypeProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;

public class NBTTypeProvider<T extends LivingEntity>
extends TypeProvider<T> {
    public static final MapCodec<List<CompoundTag>> VARIANT_DATA_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)CompoundTag.CODEC).fieldOf("variants").flatXmap(map -> {
        ArrayList variantData = new ArrayList();
        map.entrySet().stream().sorted(Comparator.comparingInt(entry -> Integer.parseInt((String)entry.getKey()))).forEach(entry -> variantData.add((CompoundTag)entry.getValue()));
        return DataResult.success(variantData);
    }, list -> {
        HashMap<String, CompoundTag> map = new HashMap<String, CompoundTag>();
        for (int i = 0; i < list.size(); ++i) {
            map.put(String.valueOf(i), (CompoundTag)list.get(i));
        }
        return DataResult.success(map);
    });
    public static final Codec<NBTTypeProvider<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("fallback", (Object)0).forGetter(NBTTypeProvider::getFallbackData), (App)VARIANT_DATA_CODEC.forGetter(o -> o.variantData), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("names", new HashMap()).forGetter(o -> o.nameMap)).apply((Applicative)instance, instance.stable(NBTTypeProvider::new)));
    private final int fallback;
    private final List<CompoundTag> variantData;
    private final Map<String, String> nameMap;

    public NBTTypeProvider(int fallback, List<CompoundTag> variantData, Map<String, String> nameMap) {
        this.fallback = fallback;
        this.variantData = variantData;
        this.nameMap = nameMap;
    }

    @Override
    public int getVariantData(@NotNull T entity) {
        TagValueOutput out = TagValueOutput.createWithContext((ProblemReporter)Walkers.PROBLEM_REPORTER, (HolderLookup.Provider)entity.registryAccess());
        entity.save((ValueOutput)out);
        CompoundTag tag = out.buildResult();
        int i = this.getData(tag);
        if (i != -1) {
            return i;
        }
        Walkers.LOGGER.error("{}: No Variant for entity type {} found.", (Object)this.getClass().getSimpleName(), (Object)EntityType.getKey((EntityType)entity.getType()));
        return this.getFallbackData();
    }

    @Override
    public T create(EntityType<T> type, Level world, @NotNull Player player, int data) {
        CompoundTag tag = new CompoundTag();
        this.fromData(tag, data);
        CompoundTag compoundTag = tag.copy();
        compoundTag.putString("id", Objects.requireNonNull(EntityType.getKey(type)).toString());
        return (T)((LivingEntity)EntityType.loadEntityRecursive((CompoundTag)compoundTag, (Level)world, (EntitySpawnReason)EntitySpawnReason.LOAD, entity -> entity));
    }

    public int getData(CompoundTag tag) {
        for (CompoundTag compoundTag : this.variantData) {
            boolean bool = true;
            for (String key : compoundTag.keySet()) {
                if (!tag.contains(key) || tag.get(key) != compoundTag.get(key)) {
                    bool = false;
                }
                if (bool) continue;
                break;
            }
            if (!bool) continue;
            return this.variantData.indexOf(compoundTag);
        }
        return -1;
    }

    public void fromData(CompoundTag tag, int data) {
        if (data < this.variantData.size()) {
            for (String key : this.variantData.get(data).keySet()) {
                Tag value = this.variantData.get(data).get(key);
                if (value == null) continue;
                tag.put(key, value);
            }
        }
    }

    @Override
    public int getFallbackData() {
        return this.fallback;
    }

    @Override
    public int size(Level level) {
        return this.variantData.size();
    }

    @Override
    public Component modifyText(T entity, MutableComponent text) {
        if (this.nameMap.containsKey(String.valueOf(this.getVariantData(entity)))) {
            return Component.translatable((String)this.nameMap.get(String.valueOf(this.getVariantData(entity))), (Object[])new Object[]{text});
        }
        return text;
    }
}

