/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.api.variant;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.variant.TypeProvider;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;

public class RegistryTypeProvider<T extends LivingEntity, V>
extends TypeProvider<T> {
    public static final Codec<RegistryTypeProvider<?, ?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("registry").forGetter(o -> o.registry.location()), (App)Codec.INT.optionalFieldOf("fallback", (Object)0).forGetter(RegistryTypeProvider::getFallbackData)).apply((Applicative)instance, instance.stable((r, f) -> new RegistryTypeProvider(ResourceKey.createRegistryKey((ResourceLocation)r), (int)f))));
    protected final ResourceKey<Registry<V>> registry;
    private final int fallback;

    public RegistryTypeProvider(ResourceKey<Registry<V>> registry) {
        this(registry, 0);
    }

    public RegistryTypeProvider(ResourceKey<Registry<V>> registry, int fallback) {
        this.registry = registry;
        this.fallback = fallback;
    }

    @Override
    public int getVariantData(T entity) {
        return this.getVariant(entity).flatMap(v -> this.getRegistry(entity.level()).map(reg -> reg.getId(v.value()))).orElse(this.getFallbackData());
    }

    @NotNull
    private Optional<Holder<V>> getVariant(@NotNull T entity) {
        TagValueOutput out = TagValueOutput.createWithContext((ProblemReporter)Walkers.PROBLEM_REPORTER, (HolderLookup.Provider)entity.registryAccess());
        entity.save((ValueOutput)out);
        CompoundTag nbt = out.buildResult();
        ValueInput in = TagValueInput.create((ProblemReporter)Walkers.PROBLEM_REPORTER, (HolderLookup.Provider)entity.registryAccess(), (CompoundTag)nbt);
        return VariantUtils.readVariant((ValueInput)in, this.registry);
    }

    @Override
    public T create(@NotNull EntityType<T> type, @NotNull Level level, @NotNull Player player, int data) {
        TagValueOutput out = TagValueOutput.createWithContext((ProblemReporter)Walkers.PROBLEM_REPORTER, (HolderLookup.Provider)level.registryAccess());
        out.putString("id", Objects.requireNonNull(EntityType.getKey(type)).toString());
        this.getRegistry(level).flatMap(reg -> reg.get(data)).ifPresent(v -> VariantUtils.writeVariant((ValueOutput)out, (Holder)v));
        return (T)((LivingEntity)EntityType.loadEntityRecursive((CompoundTag)out.buildResult(), (Level)level, (EntitySpawnReason)EntitySpawnReason.LOAD, entity -> entity));
    }

    @Override
    public int getFallbackData() {
        return this.fallback;
    }

    @Override
    public int size(@NotNull Level level) {
        return this.getRegistry(level).map(IdMap::size).orElse(this.getFallbackData());
    }

    @Override
    public Component modifyText(@NotNull T entity, MutableComponent text) {
        Optional<MutableComponent> variant = this.getVariant(entity).flatMap(Holder::unwrapKey).map(key -> Component.literal((String)this.formatTypePrefix(key.location().getPath() + " ")));
        return (Component)variant.map(c -> c.append((Component)text)).orElse(text);
    }

    @NotNull
    private Optional<Registry<V>> getRegistry(@NotNull Level level) {
        Optional reg = level.registryAccess().lookup(this.registry);
        if (reg.isEmpty()) {
            Walkers.LOGGER.error("{}: Could not find registry {}", (Object)RegistryTypeProvider.class.getSimpleName(), this.registry);
        }
        return reg;
    }
}

