/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.api.variant;

import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.blacklist.EntityBlacklist;
import dev.tocraft.walkers.api.variant.TypeProvider;
import dev.tocraft.walkers.api.variant.TypeProviderRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShapeType<T extends LivingEntity> {
    private static final List<EntityType<? extends LivingEntity>> LIVING_TYPE_CASH = new ArrayList<EntityType<? extends LivingEntity>>();
    private final EntityType<T> type;
    private final int variantData;

    public static <Z extends LivingEntity> int getDefaultVariantData(EntityType<Z> type) {
        TypeProvider<Z> provider = TypeProviderRegistry.getProvider(type);
        if (provider != null) {
            return provider.getFallbackData();
        }
        return -1;
    }

    public ShapeType(EntityType<T> type) {
        this(type, ShapeType.getDefaultVariantData(type));
    }

    public ShapeType(EntityType<T> type, int variantData) {
        this.type = type;
        this.variantData = variantData;
    }

    public ShapeType(@NotNull T entity) {
        this.type = entity.getType();
        @Nullable TypeProvider<T> provider = TypeProviderRegistry.getProvider(this.type);
        this.variantData = provider != null ? provider.getVariantData(entity) : ShapeType.getDefaultVariantData(this.type);
    }

    @NotNull
    public static <Z extends LivingEntity> ShapeType<Z> from(EntityType<Z> entityType) {
        return new ShapeType<Z>(entityType, ShapeType.getDefaultVariantData(entityType));
    }

    @Nullable
    public static <Z extends LivingEntity> ShapeType<Z> from(Z entity) {
        if (entity == null) {
            return null;
        }
        return new ShapeType<Z>(entity);
    }

    @Nullable
    public static ShapeType<?> from(@NotNull ValueInput in) {
        Optional str = in.getString("EntityID");
        if (str.isEmpty()) {
            return null;
        }
        ResourceLocation id = ResourceLocation.parse((String)((String)str.get()));
        if (!BuiltInRegistries.ENTITY_TYPE.containsKey(id)) {
            return null;
        }
        return ShapeType.from((EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(id).orElseThrow()).value(), in.getInt("Variant").orElse(-1));
    }

    @Nullable
    public static ShapeType<?> from(@NotNull CompoundTag compound) {
        Optional str = compound.getString("EntityID");
        if (str.isEmpty()) {
            return null;
        }
        ResourceLocation id = ResourceLocation.parse((String)((String)str.get()));
        if (!BuiltInRegistries.ENTITY_TYPE.containsKey(id)) {
            return null;
        }
        return ShapeType.from((EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(id).orElseThrow()).value(), compound.getInt("Variant").orElse(-1));
    }

    @Nullable
    public static <Z extends LivingEntity> ShapeType<Z> from(EntityType<Z> entityType, int variant) {
        if (variant < -1) {
            return null;
        }
        return new ShapeType<Z>(entityType, variant);
    }

    @NotNull
    public static <T extends LivingEntity> List<ShapeType<T>> getAllTypes(EntityType<T> entityType, Level level) {
        ArrayList<ShapeType<T>> types = new ArrayList<ShapeType<T>>();
        if (!EntityBlacklist.isBlacklisted(entityType)) {
            TypeProvider<T> variant = TypeProviderRegistry.getProvider(entityType);
            if (variant != null) {
                for (int i = 0; i < variant.size(level); ++i) {
                    types.add(new ShapeType<T>(entityType, i));
                }
            } else {
                types.add(ShapeType.from(entityType));
            }
        }
        return types;
    }

    @NotNull
    public static List<ShapeType<?>> getAllTypes(Level world) {
        if (LIVING_TYPE_CASH.isEmpty()) {
            for (EntityType type : BuiltInRegistries.ENTITY_TYPE) {
                try {
                    Entity instance = type.create(world, EntitySpawnReason.LOAD);
                    if (!(instance instanceof LivingEntity)) continue;
                    LIVING_TYPE_CASH.add((EntityType<? extends LivingEntity>)type);
                }
                catch (Exception e) {
                    Walkers.LOGGER.error("{}: Caught an exception while getting shape types for entity type + {}: {}", new Object[]{ShapeType.class.getSimpleName(), type.toShortString(), e});
                }
            }
        }
        ArrayList types = new ArrayList();
        for (EntityType<? extends LivingEntity> type : LIVING_TYPE_CASH) {
            types.addAll(ShapeType.getAllTypes(type, world));
        }
        return types;
    }

    public CompoundTag writeCompound() {
        CompoundTag compound = new CompoundTag();
        compound.putString("EntityID", EntityType.getKey(this.type).toString());
        compound.putInt("Variant", this.variantData);
        return compound;
    }

    public EntityType<? extends LivingEntity> getEntityType() {
        return this.type;
    }

    public T create(Level world, Player player) {
        TypeProvider<T> typeProvider = TypeProviderRegistry.getProvider(this.type);
        if (typeProvider != null && this.variantData < typeProvider.size(world)) {
            return typeProvider.create(this.type, world, player, this.variantData);
        }
        return (T)((LivingEntity)this.type.create(world, EntitySpawnReason.LOAD));
    }

    public int getVariantData() {
        return this.variantData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShapeType that = (ShapeType)o;
        return this.variantData == that.variantData && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.variantData);
    }

    public static <L extends LivingEntity> Component createTooltipText(@NotNull L entity) {
        TypeProvider<L> provider = TypeProviderRegistry.getProvider(entity.getType());
        if (provider != null) {
            return provider.modifyText(entity, Component.translatable((String)entity.getType().getDescriptionId()));
        }
        return Component.translatable((String)entity.getType().getDescriptionId());
    }
}

