/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.api.variant;

import dev.tocraft.walkers.api.variant.ShapeType;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class TypeProvider<T extends LivingEntity> {
    public ShapeType<T> create(@NotNull T entity) {
        return ShapeType.from(entity.getType(), this.getVariantData(entity));
    }

    public abstract int getVariantData(T var1);

    public abstract T create(EntityType<T> var1, Level var2, @NotNull Player var3, int var4);

    public abstract int getFallbackData();

    public abstract int size(Level var1);

    public abstract Component modifyText(T var1, MutableComponent var2);

    @NotNull
    public final String formatTypePrefix(@NotNull String prefix) {
        return String.valueOf(prefix.charAt(0)).toUpperCase(Locale.ROOT) + prefix.substring(1);
    }
}

