/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.tocraft.walkers.Walkers;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class EntityBlacklistCommands {
    public static LiteralCommandNode<CommandSourceStack> getRootNode(CommandBuildContext ctx) {
        LiteralCommandNode rootNode = Commands.literal((String)"entityBlacklist").build();
        LiteralCommandNode addToList = ((LiteralArgumentBuilder)Commands.literal((String)"add").then(Commands.argument((String)"entity", (ArgumentType)ResourceArgument.resource((CommandBuildContext)ctx, (ResourceKey)Registries.ENTITY_TYPE)).suggests(SuggestionProviders.cast((SuggestionProvider)SuggestionProviders.SUMMONABLE_ENTITIES)).executes(context -> {
            EntityBlacklistCommands.addToList((CommandSourceStack)context.getSource(), ResourceArgument.getSummonableEntityType((CommandContext)context, (String)"entity").key().location());
            return 1;
        }))).build();
        LiteralCommandNode removeFromList = ((LiteralArgumentBuilder)Commands.literal((String)"remove").then(Commands.argument((String)"entity", (ArgumentType)ResourceArgument.resource((CommandBuildContext)ctx, (ResourceKey)Registries.ENTITY_TYPE)).suggests(SuggestionProviders.cast((SuggestionProvider)SuggestionProviders.SUMMONABLE_ENTITIES)).executes(context -> {
            EntityBlacklistCommands.removeFromList((CommandSourceStack)context.getSource(), ResourceArgument.getSummonableEntityType((CommandContext)context, (String)"entity").key().location());
            return 1;
        }))).build();
        LiteralCommandNode listList = ((LiteralArgumentBuilder)Commands.literal((String)"list").executes(context -> EntityBlacklistCommands.listEntities((CommandSourceStack)context.getSource()))).build();
        LiteralCommandNode clearList = ((LiteralArgumentBuilder)Commands.literal((String)"clear").executes(context -> EntityBlacklistCommands.clearEntities((CommandSourceStack)context.getSource()))).build();
        LiteralCommandNode isWhitelist = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"isWhitelist").executes(context -> {
            EntityBlacklistCommands.isWhitelist((CommandSourceStack)context.getSource());
            return 1;
        })).then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            EntityBlacklistCommands.setIsWhitelist((CommandSourceStack)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"value"));
            return 1;
        }))).build();
        rootNode.addChild((CommandNode)listList);
        rootNode.addChild((CommandNode)clearList);
        rootNode.addChild((CommandNode)addToList);
        rootNode.addChild((CommandNode)removeFromList);
        rootNode.addChild((CommandNode)isWhitelist);
        return rootNode;
    }

    private static void isWhitelist(CommandSourceStack source) {
        source.sendSuccess(() -> Component.translatable((String)"craftedcore.config.get", (Object[])new Object[]{"entityBlacklistIsWhitelist", Walkers.CONFIG.entityBlacklistIsWhitelist}), false);
    }

    private static void setIsWhitelist(CommandSourceStack source, boolean value) {
        Walkers.CONFIG.entityBlacklistIsWhitelist = value;
        Walkers.CONFIG.save();
        for (ServerPlayer player : source.getServer().getPlayerList().getPlayers()) {
            Walkers.CONFIG.sendToPlayer(player);
        }
        source.sendSuccess(() -> Component.translatable((String)"craftedcore.config.set", (Object[])new Object[]{"entityBlacklistIsWhitelist", String.valueOf(value)}), false);
    }

    private static int clearEntities(CommandSourceStack source) {
        Walkers.CONFIG.entityBlacklist.clear();
        Walkers.CONFIG.save();
        for (ServerPlayer player : source.getServer().getPlayerList().getPlayers()) {
            Walkers.CONFIG.sendToPlayer(player);
        }
        source.sendSuccess(() -> Component.translatable((String)"walkers.entityBlacklist.clear"), false);
        return 1;
    }

    private static int listEntities(CommandSourceStack source) {
        for (String s : Walkers.CONFIG.entityBlacklist) {
            source.sendSuccess(() -> Component.translatable((String)"walkers.entityBlacklist.list", (Object[])new Object[]{s}), false);
        }
        if (Walkers.CONFIG.entityBlacklist.isEmpty()) {
            source.sendSuccess(() -> Component.translatable((String)"walkers.entityBlacklist.isEmpty"), false);
        }
        return 1;
    }

    private static void addToList(CommandSourceStack source, ResourceLocation type) {
        Walkers.CONFIG.entityBlacklist.add(type.toString());
        Walkers.CONFIG.save();
        for (ServerPlayer player : source.getServer().getPlayerList().getPlayers()) {
            Walkers.CONFIG.sendToPlayer(player);
        }
        source.sendSuccess(() -> Component.translatable((String)"walkers.entityBlacklist.add", (Object[])new Object[]{type.toString()}), false);
    }

    private static void removeFromList(CommandSourceStack source, ResourceLocation type) {
        Walkers.CONFIG.entityBlacklist.remove(type.toString());
        Walkers.CONFIG.save();
        for (ServerPlayer player : source.getServer().getPlayerList().getPlayers()) {
            Walkers.CONFIG.sendToPlayer(player);
        }
        source.sendSuccess(() -> Component.translatable((String)"walkers.entityBlacklist.remove", (Object[])new Object[]{type.toString()}), false);
    }
}

