/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.tocraft.walkers.Walkers;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class PlayerBlacklistCommands {
    public static LiteralCommandNode<CommandSourceStack> getRootNode() {
        LiteralCommandNode rootNode = Commands.literal((String)"playerBlacklist").build();
        LiteralCommandNode isWhitelist = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"isWhitelist").executes(context -> PlayerBlacklistCommands.isWhitelist((CommandSourceStack)context.getSource()))).then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> PlayerBlacklistCommands.setIsWhitelist((CommandSourceStack)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"value"))))).build();
        LiteralCommandNode preventUnlocking = ((LiteralArgumentBuilder)Commands.literal((String)"preventUnlocking").then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> PlayerBlacklistCommands.setPreventUnlocking((CommandSourceStack)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"value"))))).build();
        LiteralCommandNode preventMorphing = ((LiteralArgumentBuilder)Commands.literal((String)"preventMorphing").then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> PlayerBlacklistCommands.setPreventMorphing((CommandSourceStack)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"value"))))).build();
        LiteralCommandNode addToList = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"add").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(context -> {
            for (ServerPlayer player : EntityArgument.getPlayers((CommandContext)context, (String)"players")) {
                PlayerBlacklistCommands.addToList((CommandSourceStack)context.getSource(), player.getUUID());
            }
            return 1;
        }))).then(Commands.argument((String)"playerUUID", (ArgumentType)UuidArgument.uuid()).executes(context -> {
            PlayerBlacklistCommands.addToList((CommandSourceStack)context.getSource(), UuidArgument.getUuid((CommandContext)context, (String)"playerUUID"));
            return 1;
        }))).build();
        LiteralCommandNode removeFromList = ((LiteralArgumentBuilder)Commands.literal((String)"remove").then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(context -> {
            for (ServerPlayer player : EntityArgument.getPlayers((CommandContext)context, (String)"players")) {
                PlayerBlacklistCommands.removeFromList((CommandSourceStack)context.getSource(), player.getUUID());
            }
            return 1;
        })).then(Commands.argument((String)"playerUUID", (ArgumentType)UuidArgument.uuid()).executes(context -> {
            PlayerBlacklistCommands.removeFromList((CommandSourceStack)context.getSource(), UuidArgument.getUuid((CommandContext)context, (String)"playerUUID"));
            return 1;
        })))).build();
        LiteralCommandNode listList = ((LiteralArgumentBuilder)Commands.literal((String)"list").executes(context -> PlayerBlacklistCommands.listPlayers((CommandSourceStack)context.getSource()))).build();
        rootNode.addChild((CommandNode)isWhitelist);
        rootNode.addChild((CommandNode)preventUnlocking);
        rootNode.addChild((CommandNode)preventMorphing);
        rootNode.addChild((CommandNode)listList);
        rootNode.addChild((CommandNode)addToList);
        rootNode.addChild((CommandNode)removeFromList);
        return rootNode;
    }

    private static int isWhitelist(CommandSourceStack source) {
        source.sendSuccess(() -> Component.translatable((String)"walkers.getConfigEntry", (Object[])new Object[]{"playerBlacklistIsWhitelist", Walkers.CONFIG.playerBlacklistIsWhitelist}), false);
        return 1;
    }

    private static int setIsWhitelist(CommandSourceStack source, boolean value) {
        Walkers.CONFIG.playerBlacklistIsWhitelist = value;
        Walkers.CONFIG.save();
        for (ServerPlayer player : source.getServer().getPlayerList().getPlayers()) {
            Walkers.CONFIG.sendToPlayer(player);
        }
        source.sendSuccess(() -> Component.translatable((String)"walkers.setConfigEntry", (Object[])new Object[]{"playerBlacklistIsWhitelist", String.valueOf(value)}), false);
        return 1;
    }

    private static int setPreventUnlocking(CommandSourceStack source, boolean value) {
        Walkers.CONFIG.blacklistPreventsUnlocking = value;
        Walkers.CONFIG.save();
        for (ServerPlayer player : source.getServer().getPlayerList().getPlayers()) {
            Walkers.CONFIG.sendToPlayer(player);
        }
        source.sendSuccess(() -> Component.translatable((String)"walkers.setConfigEntry", (Object[])new Object[]{"blacklistPreventsUnlocking", String.valueOf(value)}), false);
        return 1;
    }

    private static int setPreventMorphing(CommandSourceStack source, boolean value) {
        Walkers.CONFIG.blacklistPreventsMorphing = value;
        Walkers.CONFIG.save();
        for (ServerPlayer player : source.getServer().getPlayerList().getPlayers()) {
            Walkers.CONFIG.sendToPlayer(player);
        }
        source.sendSuccess(() -> Component.translatable((String)"walkers.setConfigEntry", (Object[])new Object[]{"blacklistPreventsMorphing", String.valueOf(value)}), false);
        return 1;
    }

    private static int listPlayers(CommandSourceStack source) {
        for (UUID uuid : Walkers.CONFIG.playerUUIDBlacklist) {
            ServerPlayer player = source.getServer().getPlayerList().getPlayer(uuid);
            Component name = player != null ? player.getDisplayName() : Component.literal((String)uuid.toString());
            source.sendSuccess(() -> Component.translatable((String)"walkers.playerBlacklist.list", (Object[])new Object[]{name}), false);
        }
        if (Walkers.CONFIG.playerUUIDBlacklist.isEmpty()) {
            source.sendSuccess(() -> Component.translatable((String)"walkers.playerBlacklist.isEmpty"), false);
        }
        return 1;
    }

    private static void addToList(CommandSourceStack source, UUID uuid) {
        Walkers.CONFIG.playerUUIDBlacklist.add(uuid);
        Walkers.CONFIG.save();
        for (ServerPlayer player : source.getServer().getPlayerList().getPlayers()) {
            Walkers.CONFIG.sendToPlayer(player);
        }
        ServerPlayer player = source.getServer().getPlayerList().getPlayer(uuid);
        Component name = player != null ? player.getDisplayName() : Component.literal((String)uuid.toString());
        source.sendSuccess(() -> Component.translatable((String)"walkers.playerBlacklist.add", (Object[])new Object[]{name}), false);
    }

    private static void removeFromList(CommandSourceStack source, UUID uuid) {
        Walkers.CONFIG.playerUUIDBlacklist.remove(uuid);
        Walkers.CONFIG.save();
        for (ServerPlayer player : source.getServer().getPlayerList().getPlayers()) {
            Walkers.CONFIG.sendToPlayer(player);
        }
        ServerPlayer player = source.getServer().getPlayerList().getPlayer(uuid);
        Component name = player != null ? player.getDisplayName() : Component.literal((String)uuid.toString());
        source.sendSuccess(() -> Component.translatable((String)"walkers.playerBlacklist.remove", (Object[])new Object[]{name}), false);
    }
}

