/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.tocraft.craftedcore.event.common.CommandEvents;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.PlayerAbilities;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.api.PlayerShapeChanger;
import dev.tocraft.walkers.api.variant.ShapeType;
import dev.tocraft.walkers.command.EntityBlacklistCommands;
import dev.tocraft.walkers.command.PlayerBlacklistCommands;
import dev.tocraft.walkers.impl.PlayerDataProvider;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class WalkersCommand {
    public static void initialize() {
        CommandEvents.REGISTRATION.register((dispatcher, ctx, selection) -> WalkersCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, ctx));
    }

    private static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext ctx) {
        LiteralCommandNode rootNode = ((LiteralArgumentBuilder)Commands.literal((String)"walkers").requires(source -> source.hasPermission(2))).build();
        LiteralCommandNode remove2ndShape = ((LiteralArgumentBuilder)Commands.literal((String)"remove2ndShape").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(context -> {
            for (ServerPlayer player : EntityArgument.getPlayers((CommandContext)context, (String)"players")) {
                WalkersCommand.remove2ndShape((CommandSourceStack)context.getSource(), player);
            }
            return 1;
        }))).build();
        LiteralCommandNode change2ndShape = ((LiteralArgumentBuilder)Commands.literal((String)"change2ndShape").then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entity()).executes(context -> {
            Entity entity = EntityArgument.getEntity((CommandContext)context, (String)"entity");
            TagValueOutput out = TagValueOutput.createWithContext((ProblemReporter)Walkers.PROBLEM_REPORTER, (HolderLookup.Provider)((CommandSourceStack)context.getSource()).registryAccess());
            entity.saveWithoutId((ValueOutput)out);
            for (ServerPlayer player : EntityArgument.getPlayers((CommandContext)context, (String)"players")) {
                WalkersCommand.change2ndShape((CommandSourceStack)context.getSource(), player, EntityType.getKey((EntityType)entity.getType()), out.buildResult());
            }
            return 1;
        }))).then(((RequiredArgumentBuilder)Commands.argument((String)"shape", (ArgumentType)ResourceArgument.resource((CommandBuildContext)ctx, (ResourceKey)Registries.ENTITY_TYPE)).suggests(SuggestionProviders.cast((SuggestionProvider)SuggestionProviders.SUMMONABLE_ENTITIES)).executes(context -> {
            for (ServerPlayer player : EntityArgument.getPlayers((CommandContext)context, (String)"players")) {
                WalkersCommand.change2ndShape((CommandSourceStack)context.getSource(), player, ResourceArgument.getEntityType((CommandContext)context, (String)"shape").key().location(), null);
            }
            return 1;
        })).then(Commands.argument((String)"nbt", (ArgumentType)CompoundTagArgument.compoundTag()).executes(context -> {
            CompoundTag nbt = CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"nbt");
            for (ServerPlayer player : EntityArgument.getPlayers((CommandContext)context, (String)"players")) {
                WalkersCommand.change2ndShape((CommandSourceStack)context.getSource(), player, ResourceArgument.getEntityType((CommandContext)context, (String)"shape").key().location(), nbt);
            }
            return 1;
        }))))).build();
        LiteralCommandNode switchShape = ((LiteralArgumentBuilder)Commands.literal((String)"switchShape").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"normal").executes(context -> {
            for (ServerPlayer player : EntityArgument.getPlayers((CommandContext)context, (String)"players")) {
                WalkersCommand.switchShapeToNormal((CommandSourceStack)context.getSource(), player);
            }
            return 1;
        }))).then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entity()).executes(context -> {
            Entity entity = EntityArgument.getEntity((CommandContext)context, (String)"entity");
            TagValueOutput out = TagValueOutput.createWithContext((ProblemReporter)Walkers.PROBLEM_REPORTER, (HolderLookup.Provider)((CommandSourceStack)context.getSource()).registryAccess());
            entity.saveWithoutId((ValueOutput)out);
            for (ServerPlayer player : EntityArgument.getPlayers((CommandContext)context, (String)"players")) {
                WalkersCommand.switchShape((CommandSourceStack)context.getSource(), player, EntityType.getKey((EntityType)entity.getType()), out.buildResult());
            }
            return 1;
        }))).then(((RequiredArgumentBuilder)Commands.argument((String)"shape", (ArgumentType)ResourceArgument.resource((CommandBuildContext)ctx, (ResourceKey)Registries.ENTITY_TYPE)).suggests(SuggestionProviders.cast((SuggestionProvider)SuggestionProviders.SUMMONABLE_ENTITIES)).executes(context -> {
            for (ServerPlayer player : EntityArgument.getPlayers((CommandContext)context, (String)"players")) {
                WalkersCommand.switchShape((CommandSourceStack)context.getSource(), player, ResourceArgument.getEntityType((CommandContext)context, (String)"shape").key().location(), null);
            }
            return 1;
        })).then(Commands.argument((String)"nbt", (ArgumentType)CompoundTagArgument.compoundTag()).executes(context -> {
            CompoundTag nbt = CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"nbt");
            for (ServerPlayer player : EntityArgument.getPlayers((CommandContext)context, (String)"players")) {
                WalkersCommand.switchShape((CommandSourceStack)context.getSource(), player, ResourceArgument.getEntityType((CommandContext)context, (String)"shape").key().location(), nbt);
            }
            return 1;
        }))))).build();
        LiteralCommandNode show2ndShape = ((LiteralArgumentBuilder)Commands.literal((String)"show2ndShape").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(context -> {
            for (ServerPlayer player : EntityArgument.getPlayers((CommandContext)context, (String)"players")) {
                WalkersCommand.show2ndShape((CommandSourceStack)context.getSource(), player);
            }
            return 1;
        }))).build();
        rootNode.addChild((CommandNode)remove2ndShape);
        rootNode.addChild((CommandNode)change2ndShape);
        rootNode.addChild((CommandNode)switchShape);
        rootNode.addChild((CommandNode)show2ndShape);
        rootNode.addChild(PlayerBlacklistCommands.getRootNode());
        rootNode.addChild(EntityBlacklistCommands.getRootNode(ctx));
        dispatcher.getRoot().addChild((CommandNode)rootNode);
    }

    private static void show2ndShape(CommandSourceStack source, ServerPlayer player) {
        if (((PlayerDataProvider)player).walkers$get2ndShape() != null) {
            ShapeType<?> type = ((PlayerDataProvider)player).walkers$get2ndShape();
            if (type != null) {
                source.sendSuccess(() -> Component.translatable((String)"walkers.show2ndShapeNot_positive", (Object[])new Object[]{player.getDisplayName(), ShapeType.createTooltipText(type.create((Level)player.level(), (Player)player))}), false);
            }
        } else {
            source.sendSuccess(() -> Component.translatable((String)"walkers.show2ndShapeNot_failed", (Object[])new Object[]{player.getDisplayName()}), false);
        }
    }

    private static void remove2ndShape(CommandSourceStack source, ServerPlayer player) {
        WalkersCommand.change2ndShape(player, null);
        player.displayClientMessage((Component)Component.translatable((String)"walkers.remove_entity"), true);
        source.sendSuccess(() -> Component.translatable((String)"walkers.deletion_success", (Object[])new Object[]{player.getDisplayName()}), false);
    }

    private static void change2ndShape(CommandSourceStack source, ServerPlayer player, ResourceLocation id, @Nullable CompoundTag nbt) {
        ShapeType<EntityType> type = ShapeType.from((EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(id).orElseThrow()).value());
        MutableComponent name = Component.translatable((String)type.getEntityType().getDescriptionId());
        if (nbt != null) {
            CompoundTag copy = nbt.copy();
            copy.putString("id", id.toString());
            ServerLevel serverWorld = source.getLevel();
            Entity loaded = EntityType.loadEntityRecursive((CompoundTag)copy, (Level)serverWorld, (EntitySpawnReason)EntitySpawnReason.LOAD, it -> it);
            if (loaded instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)loaded;
                type = ShapeType.from(living);
                name = ShapeType.createTooltipText(living);
            }
        }
        if (((PlayerDataProvider)player).walkers$get2ndShape() != type) {
            WalkersCommand.change2ndShape(player, type);
            player.displayClientMessage((Component)Component.translatable((String)"walkers.unlock_entity", (Object[])new Object[]{name}), false);
            n = name;
            source.sendSuccess(() -> WalkersCommand.lambda$change2ndShape$15((Component)n, player), false);
        } else {
            n = name;
            source.sendSuccess(() -> WalkersCommand.lambda$change2ndShape$16(player, (Component)n), false);
        }
    }

    private static void switchShape(CommandSourceStack source, ServerPlayer player, ResourceLocation shape, @Nullable CompoundTag nbt) {
        Entity created;
        if (nbt != null) {
            CompoundTag copy = nbt.copy();
            copy.putString("id", shape.toString());
            ServerLevel serverWorld = source.getLevel();
            created = EntityType.loadEntityRecursive((CompoundTag)copy, (Level)serverWorld, (EntitySpawnReason)EntitySpawnReason.LOAD, it -> it);
        } else {
            EntityType entity = (EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(shape).orElseThrow()).value();
            created = entity.create((Level)player.level(), EntitySpawnReason.LOAD);
        }
        if (created instanceof LivingEntity) {
            ((PlayerDataProvider)player).walkers$updateShapes((LivingEntity)created);
            source.sendSuccess(() -> Component.translatable((String)"walkers.switchShape_success", (Object[])new Object[]{player.getDisplayName(), Component.translatable((String)created.getType().getDescriptionId())}), false);
        }
    }

    private static void switchShapeToNormal(CommandSourceStack source, ServerPlayer player) {
        boolean result = PlayerShape.updateShapes(player, null);
        if (result) {
            source.sendSuccess(() -> Component.translatable((String)"walkers.switchShape_human_success", (Object[])new Object[]{player.getDisplayName()}), false);
        }
    }

    private static void change2ndShape(ServerPlayer player, ShapeType<?> newShape) {
        ((PlayerDataProvider)player).walkers$set2ndShape(newShape);
        PlayerShapeChanger.sync(player);
        PlayerAbilities.sync(player);
    }

    private static /* synthetic */ Component lambda$change2ndShape$16(ServerPlayer player, Component n) {
        return Component.translatable((String)"walkers.already_has", (Object[])new Object[]{player.getDisplayName(), n});
    }

    private static /* synthetic */ Component lambda$change2ndShape$15(Component n, ServerPlayer player) {
        return Component.translatable((String)"walkers.grant_success", (Object[])new Object[]{n, player.getDisplayName()});
    }
}

