/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.eventhandler;

import dev.tocraft.craftedcore.event.common.EntityEvents;
import dev.tocraft.craftedcore.event.common.PlayerEvents;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.FlightHelper;
import dev.tocraft.walkers.api.PlayerHostility;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.traits.ShapeTrait;
import dev.tocraft.walkers.traits.TraitRegistry;
import dev.tocraft.walkers.traits.impl.AquaticTrait;
import dev.tocraft.walkers.traits.impl.CantInteractTrait;
import dev.tocraft.walkers.traits.impl.FlyingTrait;
import dev.tocraft.walkers.traits.impl.NocturnalTrait;
import dev.tocraft.walkers.traits.impl.RiderTrait;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ServerLevelAccessor;

public class WalkersEventHandlers {
    public static void initialize() {
        WalkersEventHandlers.registerHostilityUpdateHandler();
        WalkersEventHandlers.registerEntityRidingHandler();
        WalkersEventHandlers.registerPlayerRidingHandler();
        WalkersEventHandlers.registerLivingDeathHandler();
        EntityEvents.INTERACT_WITH_PLAYER.register((player, entity, hand) -> {
            LivingEntity shape = PlayerShape.getCurrentShape(player);
            if (shape != null) {
                for (ShapeTrait<LivingEntity> skill : TraitRegistry.get(shape, CantInteractTrait.ID)) {
                    if (((CantInteractTrait)skill).canInteractWithEntity(entity)) continue;
                    return InteractionResult.FAIL;
                }
            }
            return InteractionResult.PASS;
        });
        PlayerEvents.ALLOW_SLEEP_TIME.register((player, sleepingPos, vanillaResult) -> {
            if (TraitRegistry.has(PlayerShape.getCurrentShape(player), NocturnalTrait.ID)) {
                return !player.level().dimensionType().hasFixedTime() && player.level().getSkyDarken() < 4 ? InteractionResult.SUCCESS : InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        });
        PlayerEvents.SLEEP_FINISHED_TIME.register((level, newTime) -> {
            if (!level.dimensionType().hasFixedTime() && level.getSkyDarken() < 4 && !level.getPlayers(player -> player.isSleeping() && TraitRegistry.has(PlayerShape.getCurrentShape((Player)player), NocturnalTrait.ID)).isEmpty()) {
                return newTime + level.getDayTime() % 24000L > 12000L ? 13000L : -11000L;
            }
            return newTime;
        });
        PlayerEvents.AWARD_ADVANCEMENT.register((player, advancement, criterionKey) -> {
            if (Walkers.hasFlyingPermissions(player)) {
                FlightHelper.grantFlightTo(player);
                FlightHelper.updateFlyingSpeed((Player)player);
                player.onUpdateAbilities();
            }
        });
        PlayerEvents.DESTROY_SPEED.register((player, speed) -> {
            float newSpeed = speed;
            if (!player.onGround()) {
                if (TraitRegistry.has(PlayerShape.getCurrentShape(player), FlyingTrait.ID)) {
                    newSpeed *= 5.0f;
                } else if (player.isEyeInFluid(FluidTags.WATER)) {
                    for (ShapeTrait<LivingEntity> aquaticTrait : TraitRegistry.get(PlayerShape.getCurrentShape(player), AquaticTrait.ID)) {
                        if (!((AquaticTrait)aquaticTrait).isAquatic) continue;
                        newSpeed *= 5.0f;
                        break;
                    }
                }
            }
            if (player.isEyeInFluid(FluidTags.WATER)) {
                for (ShapeTrait<LivingEntity> aquaticTrait : TraitRegistry.get(PlayerShape.getCurrentShape(player), AquaticTrait.ID)) {
                    if (!((AquaticTrait)aquaticTrait).isAquatic) continue;
                    newSpeed *= 5.0f;
                    break;
                }
            }
            return newSpeed;
        });
    }

    public static void registerHostilityUpdateHandler() {
        EntityEvents.INTERACT_WITH_PLAYER.register((player, entity, hand) -> {
            if (!player.level().isClientSide && Walkers.CONFIG.playerCanTriggerHostiles && entity instanceof Monster) {
                PlayerHostility.set(player, Walkers.CONFIG.hostilityTime);
            }
            return InteractionResult.PASS;
        });
    }

    public static void registerEntityRidingHandler() {
        EntityEvents.INTERACT_WITH_PLAYER.register((player, entity, hand) -> {
            LivingEntity shape = PlayerShape.getCurrentShape(player);
            if (shape != null && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                for (RiderTrait riderTrait : TraitRegistry.get(shape, RiderTrait.ID).stream().map(entry -> (RiderTrait)entry).toList()) {
                    Player rideablePlayer;
                    if (!riderTrait.isRideable(livingEntity) && (!(livingEntity instanceof Player) || !riderTrait.isRideable(PlayerShape.getCurrentShape(rideablePlayer = (Player)livingEntity)))) continue;
                    player.startRiding(entity);
                    return InteractionResult.PASS;
                }
            }
            return InteractionResult.PASS;
        });
    }

    public static void registerPlayerRidingHandler() {
        EntityEvents.INTERACT_WITH_PLAYER.register((player, entity, hand) -> {
            Player playerToBeRidden;
            if (entity instanceof Player && PlayerShape.getCurrentShape(playerToBeRidden = (Player)entity) instanceof AbstractHorse) {
                player.startRiding((Entity)playerToBeRidden, true);
            }
            return InteractionResult.PASS;
        });
    }

    public static void registerLivingDeathHandler() {
        EntityEvents.LIVING_DEATH.register((entity, damageSource) -> {
            if (!entity.level().isClientSide() && entity instanceof Villager) {
                Player player;
                Villager villager = (Villager)entity;
                Entity patt0$temp = damageSource.getEntity();
                if (patt0$temp instanceof Player && PlayerShape.getCurrentShape(player = (Player)patt0$temp) instanceof Zombie && (player.level().getDifficulty() == Difficulty.HARD || !player.getRandom().nextBoolean())) {
                    villager.convertTo(EntityType.ZOMBIE_VILLAGER, ConversionParams.single((Mob)villager, (boolean)false, (boolean)false), zombieVillager -> {
                        zombieVillager.finalizeSpawn((ServerLevelAccessor)player.level(), player.level().getCurrentDifficultyAt(zombieVillager.blockPosition()), EntitySpawnReason.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true));
                        zombieVillager.setTradeOffers(villager.getOffers());
                        zombieVillager.setVillagerData(villager.getVillagerData());
                        zombieVillager.setGossips(villager.getGossips().copy());
                        zombieVillager.setVillagerXp(villager.getVillagerXp());
                    });
                }
            }
            return InteractionResult.PASS;
        });
    }
}

