/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.impl.tick;

import dev.tocraft.craftedcore.event.client.ClientTickEvents;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.WalkersClient;
import dev.tocraft.walkers.ability.AbilityRegistry;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.api.blacklist.EntityBlacklist;
import dev.tocraft.walkers.api.platform.ApiLevel;
import dev.tocraft.walkers.api.variant.ShapeType;
import dev.tocraft.walkers.impl.PlayerDataProvider;
import dev.tocraft.walkers.network.ClientNetworking;
import dev.tocraft.walkers.network.impl.SwapPackets;
import dev.tocraft.walkers.network.impl.SwapVariantPackets;
import dev.tocraft.walkers.network.impl.UnlockPackets;
import dev.tocraft.walkers.screen.hud.VariantMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class KeyPressHandler
implements ClientTickEvents.Client {
    private float currentTimer = 0.0f;

    public void tick(@NotNull Minecraft client) {
        if (client.player != null) {
            if (WalkersClient.ABILITY_KEY.consumeClick()) {
                this.handleAbilityKey(client);
            }
            if (WalkersClient.TRANSFORM_KEY.consumeClick()) {
                if (ApiLevel.getCurrentLevel().canMorph) {
                    SwapPackets.sendSwapRequest();
                } else {
                    client.player.displayClientMessage((Component)Component.translatable((String)"walkers.feature_not_available"), true);
                }
            }
            if (WalkersClient.VARIANTS_MENU_KEY.consumeClick() && Walkers.CONFIG.unlockEveryVariant) {
                if (ApiLevel.getCurrentLevel().allowVariantsMenu) {
                    LivingEntity shape = PlayerShape.getCurrentShape((Player)client.player);
                    if (shape != null) {
                        ShapeType<LivingEntity> shapeType = ShapeType.from(shape);
                        if (WalkersClient.isRenderingVariantsMenu) {
                            SwapVariantPackets.sendSwapRequest(shapeType.getVariantData() + WalkersClient.variantOffset);
                            VariantMenu.clearEntities();
                        } else if (Walkers.CONFIG.show_variants_menu_guide) {
                            client.player.displayClientMessage((Component)Component.translatable((String)"walkers.variants_menu_guide", (Object[])new Object[]{WalkersClient.VARIANTS_MENU_KEY.getTranslatedKeyMessage()}), true);
                            Walkers.CONFIG.show_variants_menu_guide = false;
                            if (client.isSingleplayer()) {
                                Walkers.CONFIG.save();
                            }
                        }
                        WalkersClient.variantOffset = 0;
                        WalkersClient.isRenderingVariantsMenu = !WalkersClient.isRenderingVariantsMenu;
                    }
                } else {
                    client.player.displayClientMessage((Component)Component.translatable((String)"walkers.feature_not_available"), true);
                }
            }
            if (WalkersClient.isRenderingVariantsMenu && (client.options.hideGui || !Walkers.CONFIG.unlockEveryVariant || client.screen != null || PlayerShape.getCurrentShape((Player)client.player) == null)) {
                WalkersClient.isRenderingVariantsMenu = false;
            }
            if (WalkersClient.UNLOCK_KEY.isDown()) {
                if (ApiLevel.getCurrentLevel().canUnlock) {
                    this.handleUnlockKey(client);
                } else {
                    client.player.displayClientMessage((Component)Component.translatable((String)"walkers.feature_not_available"), true);
                }
            } else if (this.currentTimer != Walkers.CONFIG.unlockTimer) {
                this.currentTimer = Walkers.CONFIG.unlockTimer;
            }
        }
    }

    private void handleAbilityKey(@NotNull Minecraft client) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)client.player);
        if (shape != null && AbilityRegistry.has(shape)) {
            ClientNetworking.sendAbilityRequest();
        }
    }

    private void handleUnlockKey(@NotNull Minecraft client) {
        if (Walkers.isPlayerBlacklisted(client.player.getUUID()) && Walkers.CONFIG.blacklistPreventsUnlocking) {
            client.player.displayClientMessage((Component)Component.translatable((String)"walkers.player_blacklisted"), true);
            return;
        }
        HitResult hit = client.hitResult;
        if ((((PlayerDataProvider)client.player).walkers$get2ndShape() == null || Walkers.CONFIG.unlockOverridesCurrentShape) && hit instanceof EntityHitResult) {
            LivingEntity living;
            ShapeType<LivingEntity> type;
            Entity entityHit = ((EntityHitResult)hit).getEntity();
            if (entityHit instanceof LivingEntity && (type = ShapeType.from(living = (LivingEntity)entityHit)) != null) {
                if (EntityBlacklist.isBlacklisted(type.getEntityType())) {
                    client.player.displayClientMessage((Component)Component.translatable((String)"walkers.unlock_entity_blacklisted"), true);
                } else if (this.currentTimer <= 0.0f) {
                    UnlockPackets.sendUnlockRequest(type);
                    MutableComponent name = Component.translatable((String)type.getEntityType().getDescriptionId());
                    client.player.displayClientMessage((Component)Component.translatable((String)"walkers.unlock_entity", (Object[])new Object[]{name}), true);
                    this.currentTimer = Walkers.CONFIG.unlockTimer;
                } else {
                    client.player.displayClientMessage((Component)Component.translatable((String)"walkers.unlock_progress"), true);
                    this.currentTimer -= 1.0f;
                }
            }
        } else {
            this.currentTimer = Walkers.CONFIG.unlockTimer;
        }
    }
}

