/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.impl.tick.shapes;

import dev.tocraft.walkers.api.WalkersTickHandler;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.player.Player;

public class FrogTickHandler
implements WalkersTickHandler<Frog> {
    @Override
    public void tick(Player player, Frog frog) {
        if (player.level().isClientSide) {
            boolean swim;
            boolean isInWater = player.isInWater();
            boolean walk = player.onGround() && player.getDeltaMovement().horizontalDistanceSqr() > 1.0E-6 && !isInWater;
            boolean bl = swim = player.getDeltaMovement().horizontalDistanceSqr() > 1.0E-6 && isInWater;
            if (!(player.onGround() || swim || walk || isInWater)) {
                frog.jumpAnimationState.startIfStopped(frog.tickCount);
            } else {
                frog.jumpAnimationState.stop();
            }
            if (swim) {
                frog.swimIdleAnimationState.stop();
            } else if (isInWater) {
                frog.swimIdleAnimationState.startIfStopped(frog.tickCount);
            } else {
                frog.swimIdleAnimationState.stop();
            }
            if (player.level().random.nextDouble() <= 0.001) {
                frog.croakAnimationState.start(player.tickCount);
            }
            if (player.swinging) {
                frog.tongueAnimationState.startIfStopped(player.tickCount);
            } else {
                frog.tongueAnimationState.stop();
            }
        } else {
            player.addEffect(new MobEffectInstance(MobEffects.JUMP_BOOST, 40, 2, true, false));
        }
    }
}

