/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.impl.variant;

import dev.tocraft.walkers.api.variant.TypeProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PandaTypeProvider
extends TypeProvider<Panda> {
    @Override
    public int getVariantData(Panda entity) {
        return entity.getMainGene().getId();
    }

    @Override
    public Panda create(EntityType<Panda> type, Level level, @NotNull Player player, int data) {
        Panda panda = new Panda(type, level);
        panda.setMainGene(Panda.Gene.byId((int)data));
        return panda;
    }

    @Override
    public int getFallbackData() {
        return Panda.Gene.NORMAL.getId();
    }

    @Override
    public int size(Level level) {
        return Panda.Gene.values().length;
    }

    @Override
    public Component modifyText(@NotNull Panda entity, MutableComponent text) {
        Panda.Gene gene = entity.getMainGene();
        if (gene.equals((Object)Panda.Gene.NORMAL)) {
            return text;
        }
        String variantName = gene.getSerializedName();
        return Component.literal((String)(this.formatTypePrefix(variantName) + " ")).append((Component)text);
    }
}

