/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.impl.variant;

import com.google.common.collect.ImmutableMap;
import dev.tocraft.walkers.api.variant.TypeProvider;
import dev.tocraft.walkers.mixin.accessor.ParrotAccessor;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ParrotTypeProvider
extends TypeProvider<Parrot> {
    private static final ImmutableMap<Integer, String> PREFIX_BY_ID = ImmutableMap.builder().put((Object)0, (Object)"Red Blue").put((Object)1, (Object)"Blue").put((Object)2, (Object)"Green").put((Object)3, (Object)"Yellow Blue").put((Object)4, (Object)"Gray").build();

    @Override
    public int getVariantData(@NotNull Parrot entity) {
        return entity.getVariant().getId();
    }

    @Override
    public Parrot create(EntityType<Parrot> type, Level world, @NotNull Player player, int data) {
        Parrot parrot = new Parrot(type, world);
        ((ParrotAccessor)parrot).callSetVariant(Parrot.Variant.byId((int)data));
        return parrot;
    }

    @Override
    public int getFallbackData() {
        return 0;
    }

    @Override
    public int size(Level level) {
        return Parrot.Variant.values().length;
    }

    @Override
    public Component modifyText(Parrot parrot, MutableComponent text) {
        int variant = this.getVariantData(parrot);
        return Component.literal((String)(PREFIX_BY_ID.containsKey((Object)variant) ? (String)PREFIX_BY_ID.get((Object)variant) + " " : "")).append((Component)text);
    }
}

