/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.impl.variant;

import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.variant.TypeProvider;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class VillagerTypeProvider
extends TypeProvider<Villager> {
    @Override
    public int getVariantData(@NotNull Villager entity) {
        return BuiltInRegistries.VILLAGER_PROFESSION.getId((Object)((VillagerProfession)entity.getVillagerData().profession().value()));
    }

    @Override
    public Villager create(EntityType<Villager> type, Level level, @NotNull Player player, int data) {
        Villager villager = new Villager(type, level);
        if (Walkers.CONFIG.multiVectorVariants > 0) {
            Holder villagerType = Walkers.CONFIG.multiVectorVariants == 2 ? (Holder)BuiltInRegistries.VILLAGER_TYPE.get(VillagerType.byBiome((Holder)level.getBiome(player.blockPosition()))).orElseThrow() : (Holder)BuiltInRegistries.VILLAGER_TYPE.get(new Random().nextInt(0, BuiltInRegistries.VILLAGER_TYPE.size() - 1)).orElseThrow();
            villager.setVillagerData(villager.getVillagerData().withProfession((Holder)BuiltInRegistries.VILLAGER_PROFESSION.get(data).orElseThrow()).withType(villagerType));
        } else {
            villager.setVillagerData(villager.getVillagerData().withProfession((Holder)BuiltInRegistries.VILLAGER_PROFESSION.get(data).orElseThrow()));
        }
        return villager;
    }

    @Override
    public int getFallbackData() {
        return 0;
    }

    @Override
    public int size(Level level) {
        return BuiltInRegistries.VILLAGER_PROFESSION.size();
    }

    @Override
    public Component modifyText(@NotNull Villager entity, MutableComponent text) {
        return Component.literal((String)this.formatTypePrefix(entity.getVillagerData().profession().unwrapKey().map(k -> k.location().getPath() + " ").orElse(""))).append((Component)text);
    }
}

