/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.integrations.impl;

import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.variant.TypeProvider;
import dev.tocraft.walkers.api.variant.TypeProviderRegistry;
import dev.tocraft.walkers.integrations.AbstractIntegration;
import dev.tocraft.walkers.integrations.impl.GuardVillagersIntegration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;

public class MoreMobVariantsIntegration
extends AbstractIntegration {
    public static final String MODID = "moremobvariants";

    @Override
    public void registerTypeProvider() {
        MoreMobVariantsIntegration.registerMMVTypeProvider(EntityType.CAT);
        MoreMobVariantsIntegration.registerMMVTypeProvider(EntityType.CHICKEN);
        MoreMobVariantsIntegration.registerMMVTypeProvider(EntityType.COW);
        MoreMobVariantsIntegration.registerMMVTypeProvider(EntityType.SKELETON);
        MoreMobVariantsIntegration.registerMMVTypeProvider(EntityType.SPIDER);
        MoreMobVariantsIntegration.registerMMVTypeProvider(EntityType.WOLF);
        MoreMobVariantsIntegration.registerMMVTypeProvider(EntityType.ZOMBIE);
    }

    private static <L extends LivingEntity> void registerMMVTypeProvider(EntityType<L> type) {
        TypeProviderRegistry.register(type, new MMVTypeProvider<L>(type));
    }

    private static List<ResourceLocation> getVariants(EntityType<?> type) {
        try {
            Class<?> variantsClass = Class.forName("com.github.nyuppo.config.Variants");
            Method getVariants = variantsClass.getDeclaredMethod("getVariants", EntityType.class);
            List variants = (List)getVariants.invoke(null, type);
            ArrayList<ResourceLocation> variantIds = new ArrayList<ResourceLocation>();
            for (Object variant : variants) {
                ResourceLocation id = (ResourceLocation)variant.getClass().getDeclaredMethod("getIdentifier", new Class[0]).invoke(variant, new Object[0]);
                variantIds.add(id);
            }
            return variantIds;
        }
        catch (ReflectiveOperationException e) {
            Walkers.LOGGER.error("{}: failed to get the mob blacklist for {}: {}", new Object[]{GuardVillagersIntegration.class.getSimpleName(), MODID, e});
            return new ArrayList<ResourceLocation>();
        }
    }

    private static class MMVTypeProvider<L extends LivingEntity>
    extends TypeProvider<L> {
        private final EntityType<L> type;

        public MMVTypeProvider(EntityType<L> type) {
            this.type = type;
        }

        @Override
        public int getVariantData(L entity) {
            List<ResourceLocation> variants = MoreMobVariantsIntegration.getVariants(this.type);
            TagValueOutput out = TagValueOutput.createWithContext((ProblemReporter)Walkers.PROBLEM_REPORTER, (HolderLookup.Provider)entity.level().registryAccess());
            entity.saveWithoutId((ValueOutput)out);
            CompoundTag nbt = out.buildResult();
            Optional str = nbt.getString("VariantID");
            if (str.isEmpty()) {
                return this.getFallbackData();
            }
            ResourceLocation id = ResourceLocation.parse((String)((String)str.get()));
            return variants.indexOf(id);
        }

        @Override
        public L create(EntityType<L> type, Level world, @NotNull Player player, int data) {
            CompoundTag nbt = new CompoundTag();
            nbt.putString("id", EntityType.getKey(type).toString());
            ResourceLocation variantId = MoreMobVariantsIntegration.getVariants(type).get(data);
            nbt.putString("VariantID", variantId.toString());
            return (L)((LivingEntity)EntityType.loadEntityRecursive((CompoundTag)nbt, (Level)world, (EntitySpawnReason)EntitySpawnReason.LOAD, entity -> entity));
        }

        @Override
        public int getFallbackData() {
            return 0;
        }

        @Override
        public int size(Level level) {
            return MoreMobVariantsIntegration.getVariants(this.type).size() - 1;
        }

        @Override
        @NotNull
        public Component modifyText(@NotNull L entity, MutableComponent text) {
            List<ResourceLocation> variants = MoreMobVariantsIntegration.getVariants(this.type);
            TagValueOutput out = TagValueOutput.createWithContext((ProblemReporter)Walkers.PROBLEM_REPORTER, (HolderLookup.Provider)entity.level().registryAccess());
            entity.saveWithoutId((ValueOutput)out);
            CompoundTag nbt = out.buildResult();
            String str = nbt.getString("VariantID").orElse("");
            return Component.literal((String)(this.formatTypePrefix(str) + " ")).append((Component)text);
        }
    }
}

