/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.integrations.impl;

import dev.tocraft.walkers.ability.AbilityRegistry;
import dev.tocraft.walkers.ability.impl.generic.ExplosionAbility;
import dev.tocraft.walkers.ability.impl.generic.JumpAbility;
import dev.tocraft.walkers.ability.impl.generic.ShootSnowballAbility;
import dev.tocraft.walkers.ability.impl.generic.TeleportationAbility;
import dev.tocraft.walkers.integrations.AbstractIntegration;
import dev.tocraft.walkers.traits.TraitRegistry;
import dev.tocraft.walkers.traits.impl.BurnInDaylightTrait;
import dev.tocraft.walkers.traits.impl.ClimbBlocksTrait;
import dev.tocraft.walkers.traits.impl.TemperatureTrait;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;

public class MutantMonstersIntegration
extends AbstractIntegration {
    public static final String MODID = "mutantmonsters";
    private static final ResourceLocation CREEPER_MINION = ResourceLocation.fromNamespaceAndPath((String)"mutantmonsters", (String)"creeper_minion");
    private static final ResourceLocation MUTANT_CREEPER = ResourceLocation.fromNamespaceAndPath((String)"mutantmonsters", (String)"mutant_creeper");
    private static final ResourceLocation MUTANT_ENDERMAN = ResourceLocation.fromNamespaceAndPath((String)"mutantmonsters", (String)"mutant_enderman");
    private static final ResourceLocation MUTANT_SKELETON = ResourceLocation.fromNamespaceAndPath((String)"mutantmonsters", (String)"mutant_skeleton");
    private static final ResourceLocation MUTANT_SNOW_GOLEM = ResourceLocation.fromNamespaceAndPath((String)"mutantmonsters", (String)"mutant_snow_golem");
    private static final ResourceLocation MUTANT_ZOMBIE = ResourceLocation.fromNamespaceAndPath((String)"mutantmonsters", (String)"mutant_zombie");
    private static final ResourceLocation SPIDER_PIG = ResourceLocation.fromNamespaceAndPath((String)"mutantmonsters", (String)"spider_pig");

    @Override
    public void registerTraits() {
        TraitRegistry.registerByType((EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(MUTANT_SKELETON).orElseThrow()).value(), new BurnInDaylightTrait());
        TraitRegistry.registerByType(MutantMonstersIntegration.getType(MUTANT_SNOW_GOLEM), new TemperatureTrait());
        TraitRegistry.registerByType(MutantMonstersIntegration.getType(MUTANT_ZOMBIE), new BurnInDaylightTrait());
        TraitRegistry.registerByType(MutantMonstersIntegration.getType(SPIDER_PIG), new ClimbBlocksTrait());
    }

    @Override
    public void registerAbilities() {
        AbilityRegistry.registerByType(MutantMonstersIntegration.getType(CREEPER_MINION), new ExplosionAbility());
        AbilityRegistry.registerByType(MutantMonstersIntegration.getType(MUTANT_CREEPER), new ExplosionAbility(4.0f));
        AbilityRegistry.registerByType(MutantMonstersIntegration.getType(MUTANT_ENDERMAN), new TeleportationAbility());
        AbilityRegistry.registerByType(MutantMonstersIntegration.getType(MUTANT_SNOW_GOLEM), new ShootSnowballAbility());
        AbilityRegistry.registerByType(MutantMonstersIntegration.getType(SPIDER_PIG), new JumpAbility());
    }

    private static EntityType<? extends Mob> getType(ResourceLocation id) {
        return (EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(id).orElseThrow()).value();
    }
}

