/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin;

import dev.tocraft.walkers.api.PlayerShape;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AvoidEntityGoal.class})
public class AvoidEntityGoalMixin<T extends LivingEntity> {
    @Shadow
    protected T toAvoid;
    @Final
    @Shadow
    protected PathfinderMob mob;

    @Inject(method={"canUse()Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void onCanUse(CallbackInfoReturnable<Boolean> cir) {
        T t;
        if (((Boolean)cir.getReturnValue()).booleanValue() && (t = this.toAvoid) instanceof Player) {
            Player player = (Player)t;
            if (this.mob instanceof Cat || this.mob instanceof Ocelot) {
                if (PlayerShape.getCurrentShape(player) instanceof Ocelot || PlayerShape.getCurrentShape(player) instanceof Cat) {
                    cir.setReturnValue((Object)false);
                }
            } else if (this.mob instanceof Rabbit && PlayerShape.getCurrentShape(player) instanceof Rabbit) {
                cir.setReturnValue((Object)false);
            }
        }
    }
}

