/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin;

import com.google.common.base.Suppliers;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import dev.tocraft.walkers.api.PlayerShape;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Consumable.class})
public class ConsumableMixin {
    @Unique
    private static final Supplier<List<Item>> WOLVES_IGNORE = Suppliers.memoize(() -> Arrays.asList(Items.CHICKEN, Items.PUFFERFISH, Items.ROTTEN_FLESH));

    @WrapWithCondition(method={"onConsume(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="INVOKE", target="Ljava/util/List;forEach(Ljava/util/function/Consumer;)V")})
    private boolean onConsume(List<ConsumeEffect> instance, Consumer<? super ConsumeEffect> consumer, @Local(argsOnly=true, ordinal=0) LivingEntity entity, @Local(argsOnly=true, ordinal=0) ItemStack stack) {
        Player player;
        LivingEntity shape;
        if (entity instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)entity)) instanceof Wolf) {
            return !WOLVES_IGNORE.get().contains(stack.getItem());
        }
        return true;
    }
}

