/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin;

import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.PlayerShape;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class DisableSlotsMixin {
    @Inject(method={"getItemBySlot(Lnet/minecraft/world/entity/EquipmentSlot;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetAmorItem(@NotNull EquipmentSlot slot, CallbackInfoReturnable<ItemStack> cir) {
        if (slot.isArmor() && this.walkers$blockEquipSlot(slot)) {
            cir.setReturnValue((Object)ItemStack.EMPTY);
        }
    }

    @Inject(method={"canUseSlot(Lnet/minecraft/world/entity/EquipmentSlot;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCanUseSlot(@NotNull EquipmentSlot slot, CallbackInfoReturnable<Boolean> cir) {
        if (slot.isArmor() && this.walkers$blockEquipSlot(slot)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    private boolean walkers$blockEquipSlot(EquipmentSlot slot) {
        DisableSlotsMixin disableSlotsMixin = this;
        if (disableSlotsMixin instanceof Player) {
            Player player = (Player)disableSlotsMixin;
            LivingEntity shape = PlayerShape.getCurrentShape(player);
            if (shape == null) {
                return false;
            }
            String shapeKey = EntityType.getKey((EntityType)shape.getType()).toString();
            HashSet<String> blockedSlots = new HashSet<String>(this.walkers$getBlockedSlots("*"));
            blockedSlots.addAll(this.walkers$getBlockedSlots(shapeKey));
            return blockedSlots.contains(slot.getName());
        }
        return false;
    }

    @Unique
    private List<String> walkers$getBlockedSlots(String key) {
        return Walkers.CONFIG.blockEquipmentSlots.getOrDefault(key, Collections.emptyList());
    }
}

