/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin;

import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.traits.TraitRegistry;
import dev.tocraft.walkers.traits.impl.NoPhysicsTrait;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Inject(method={"fireImmune()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void fireImmune(CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity shape;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)entityMixin)) != null) {
            cir.setReturnValue((Object)shape.getType().fireImmune());
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void goThroughBlocks(CallbackInfo ci) {
        Player player;
        LivingEntity shape;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)entityMixin)) != null && TraitRegistry.has(shape, NoPhysicsTrait.ID)) {
            player.noPhysics = true;
        }
    }

    @Inject(method={"removePassenger(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="TAIL")})
    private void removePlayerVehicle(Entity passenger, CallbackInfo ci) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof ServerPlayer) {
            ServerPlayer vehicle = (ServerPlayer)entityMixin;
            if (!vehicle.level().isClientSide) {
                vehicle.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)vehicle));
            }
        }
    }

    @Inject(method={"addPassenger(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="TAIL")})
    private void addPlayerVehicle(Entity passenger, CallbackInfo ci) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof ServerPlayer) {
            ServerPlayer vehicle = (ServerPlayer)entityMixin;
            if (!vehicle.level().isClientSide) {
                vehicle.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)vehicle));
            }
        }
    }
}

