/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin;

import dev.tocraft.walkers.api.PlayerShape;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FoodProperties.class})
public class FoodPropertiesMixin {
    @Inject(method={"onConsume(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/component/Consumable;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;eat(Lnet/minecraft/world/food/FoodProperties;)V")})
    private void regenerateWoolFromFood(Level level, LivingEntity entity, ItemStack itemStack, Consumable consumable, CallbackInfo ci) {
        Sheep sheepShape;
        Player player;
        LivingEntity shape;
        if (entity instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)entity)) instanceof Sheep && (sheepShape = (Sheep)shape).isSheared()) {
            sheepShape.setSheared(false);
        }
    }

    @Inject(method={"onConsume(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/component/Consumable;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;eat(Lnet/minecraft/world/food/FoodProperties;)V")})
    private void dieFromCookies(Level level, LivingEntity entity, ItemStack itemStack, Consumable consumable, CallbackInfo ci) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (level instanceof ServerLevel) {
                LivingEntity shape;
                ServerLevel serverLevel = (ServerLevel)level;
                if (itemStack.is(Items.COOKIE) && (shape = PlayerShape.getCurrentShape(player)) instanceof Parrot) {
                    player.addEffect(new MobEffectInstance(MobEffects.POISON, 900));
                    if (player.isCreative() || !entity.isInvulnerable()) {
                        entity.hurtServer(serverLevel, level.damageSources().playerAttack(player), Float.MAX_VALUE);
                    }
                }
            }
        }
    }
}

