/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.impl.NearbySongAccessor;
import dev.tocraft.walkers.impl.ShapeDataProvider;
import dev.tocraft.walkers.mixin.accessor.LivingEntityAccessor;
import dev.tocraft.walkers.traits.ShapeTrait;
import dev.tocraft.walkers.traits.TraitRegistry;
import dev.tocraft.walkers.traits.impl.AttackForHealthTrait;
import dev.tocraft.walkers.traits.impl.CantFreezeTrait;
import dev.tocraft.walkers.traits.impl.ClimbBlocksTrait;
import dev.tocraft.walkers.traits.impl.FlyingTrait;
import dev.tocraft.walkers.traits.impl.ImmunityTrait;
import dev.tocraft.walkers.traits.impl.MobEffectTrait;
import dev.tocraft.walkers.traits.impl.SlowFallingTrait;
import dev.tocraft.walkers.traits.impl.StandOnFluidTrait;
import dev.tocraft.walkers.traits.impl.TemperatureTrait;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements NearbySongAccessor {
    @Shadow
    @Final
    private static ResourceLocation SPRINTING_MODIFIER_ID;
    @Unique
    private boolean walkers$nearbySongPlaying = false;
    @Unique
    private static final AttributeModifier walkers$HORSE_SPRINT_MODIFIER;

    protected LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @WrapOperation(method={"getEffectiveGravity()D"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/core/Holder;)Z", ordinal=0)})
    private boolean slowFall(LivingEntity instance, Holder<MobEffect> effect, Operation<Boolean> original) {
        Player player;
        LivingEntity shape;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)livingEntityMixin)) != null) {
            boolean bool = false;
            for (FlyingTrait flyingTrait : TraitRegistry.get(shape, FlyingTrait.ID).stream().map(trait -> (FlyingTrait)trait).toList()) {
                if (!flyingTrait.slowFalling) continue;
                bool = true;
                break;
            }
            if (!this.isShiftKeyDown() && (bool || TraitRegistry.has(shape, SlowFallingTrait.ID))) {
                return true;
            }
        }
        return (Boolean)original.call(new Object[]{instance, effect});
    }

    @Inject(method={"causeFallDamage(DFLnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void causeFallDamage(double fallDistance, float damageMultiplier, DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity shape;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)livingEntityMixin)) != null) {
            boolean takesFallDamage = shape.causeFallDamage(fallDistance, damageMultiplier, damageSource);
            int damageAmount = ((LivingEntityAccessor)shape).callCalculateFallDamage(fallDistance, damageMultiplier);
            if (takesFallDamage && damageAmount > 0) {
                LivingEntity.Fallsounds fallSounds = shape.getFallSounds();
                this.playSound(damageAmount > 4 ? fallSounds.big() : fallSounds.small(), 1.0f, 1.0f);
                ((LivingEntityAccessor)shape).callPlayBlockFallSound();
                this.hurt(this.damageSources().fall(), damageAmount);
                cir.setReturnValue((Object)true);
            } else {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"hasEffect(Lnet/minecraft/core/Holder;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void returnHasNightVision(Holder<MobEffect> effect, CallbackInfoReturnable<Boolean> cir) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player) {
            Player player = (Player)livingEntityMixin;
            LivingEntity shape = PlayerShape.getCurrentShape(player);
            if (TraitRegistry.has(shape, MobEffectTrait.ID)) {
                List<MobEffectTrait> traitList = TraitRegistry.get(shape, MobEffectTrait.ID).stream().map(trait -> (MobEffectTrait)trait).toList();
                for (MobEffectTrait mobEffectTrait : traitList) {
                    if (mobEffectTrait.showInInventory || !mobEffectTrait.applyToSelf || !effect.equals((Object)mobEffectTrait.mobEffectInstance.getEffect())) continue;
                    cir.setReturnValue((Object)true);
                    return;
                }
            }
            for (ShapeTrait<LivingEntity> immunityTrait : TraitRegistry.get(shape, ImmunityTrait.ID)) {
                if (!((ImmunityTrait)immunityTrait).effect.equals(effect.value())) continue;
                cir.setReturnValue((Object)false);
                return;
            }
        }
    }

    @Inject(method={"getEffect(Lnet/minecraft/core/Holder;)Lnet/minecraft/world/effect/MobEffectInstance;"}, at={@At(value="HEAD")}, cancellable=true)
    private void returnNightVisionInstance(Holder<MobEffect> effect, CallbackInfoReturnable<MobEffectInstance> cir) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player) {
            Player player = (Player)livingEntityMixin;
            LivingEntity shape = PlayerShape.getCurrentShape(player);
            if (TraitRegistry.has(shape, MobEffectTrait.ID)) {
                List<MobEffectTrait> traitList = TraitRegistry.get(shape, MobEffectTrait.ID).stream().map(trait -> (MobEffectTrait)trait).toList();
                for (MobEffectTrait mobEffectTrait : traitList) {
                    MobEffectInstance mobEffectInstance;
                    if (mobEffectTrait.showInInventory || !mobEffectTrait.applyToSelf || !effect.equals((Object)(mobEffectInstance = mobEffectTrait.mobEffectInstance).getEffect())) continue;
                    cir.setReturnValue((Object)new MobEffectInstance(mobEffectInstance.getEffect(), mobEffectInstance.getDuration(), mobEffectInstance.getAmplifier(), mobEffectInstance.isAmbient(), mobEffectInstance.isVisible(), mobEffectInstance.showIcon()));
                    return;
                }
            }
            for (ShapeTrait<LivingEntity> immunityTrait : TraitRegistry.get(shape, ImmunityTrait.ID)) {
                if (!((ImmunityTrait)immunityTrait).effect.equals(effect.value())) continue;
                cir.setReturnValue(null);
                return;
            }
        }
    }

    @Inject(method={"isSensitiveToWater()Z"}, at={@At(value="HEAD")}, cancellable=true)
    protected void shape_isSensitiveToWater(CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity entity;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player && (entity = PlayerShape.getCurrentShape(player = (Player)livingEntity)) != null) {
            cir.setReturnValue((Object)entity.isSensitiveToWater());
        }
    }

    @Inject(method={"setRecordPlayingNearby(Lnet/minecraft/core/BlockPos;Z)V"}, at={@At(value="RETURN")})
    @OnlyIn(value=Dist.CLIENT)
    protected void shape_setRecordPlayingNearby(BlockPos songPosition, boolean playing, CallbackInfo ci) {
        if ((LivingEntity)this instanceof Player) {
            this.walkers$nearbySongPlaying = playing;
        }
    }

    @Override
    public boolean shape_isNearbySongPlaying() {
        return this.walkers$nearbySongPlaying;
    }

    @Inject(method={"isInvertedHealAndHarm()Z"}, at={@At(value="HEAD")}, cancellable=true)
    protected void shape_isInvertedHealAndHarm(CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity shape;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)livingEntity)) != null) {
            cir.setReturnValue((Object)shape.isInvertedHealAndHarm());
        }
    }

    @Inject(method={"canStandOnFluid(Lnet/minecraft/world/level/material/FluidState;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    protected void shape_canStandOnFluid(FluidState state, CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity shape;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)livingEntity)) != null) {
            if (shape.canStandOnFluid(state)) {
                cir.setReturnValue((Object)true);
            } else {
                for (StandOnFluidTrait standOnFluidTrait : TraitRegistry.get(shape, StandOnFluidTrait.ID).stream().map(entry -> (StandOnFluidTrait)entry).toList()) {
                    if (!state.is(standOnFluidTrait.fluidTagKey)) continue;
                    cir.setReturnValue((Object)true);
                    return;
                }
            }
        }
    }

    @Inject(method={"onClimbable()Z"}, at={@At(value="HEAD")}, cancellable=true)
    protected void shape_allowSpiderClimbing(CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity shape;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)livingEntity)) != null) {
            BlockState blockState = this.level().getBlockState(this.blockPosition());
            for (ClimbBlocksTrait climbBlocksTrait : TraitRegistry.get(shape, ClimbBlocksTrait.ID).stream().map(entry -> (ClimbBlocksTrait)entry).toList()) {
                for (Block invalidBlock : climbBlocksTrait.invalidBlocks) {
                    if (!blockState.is(invalidBlock)) continue;
                    return;
                }
                if (climbBlocksTrait.validBlocks.isEmpty()) {
                    cir.setReturnValue((Object)this.horizontalCollision);
                    continue;
                }
                for (Block validBlock : climbBlocksTrait.validBlocks) {
                    if (!blockState.is(validBlock)) continue;
                    cir.setReturnValue((Object)(!climbBlocksTrait.horizontalCollision || this.horizontalCollision ? 1 : 0));
                    return;
                }
            }
        }
    }

    @Inject(method={"isSensitiveToWater()Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void handleWaterSensitivity(CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity shape;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)livingEntityMixin)) != null) {
            cir.setReturnValue((Object)shape.isSensitiveToWater());
        }
    }

    @Inject(method={"canFreeze()Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void temperatureTraitPreventFreeze(@NotNull CallbackInfoReturnable<Boolean> cir) {
        LivingEntity shape;
        if (((Boolean)cir.getReturnValue()).booleanValue() && this instanceof Player && (shape = PlayerShape.getCurrentShape((Player)this)) != null) {
            if (TraitRegistry.has(shape, CantFreezeTrait.ID)) {
                cir.setReturnValue((Object)false);
            } else {
                for (ShapeTrait<LivingEntity> temperatureTrait : TraitRegistry.get(shape, TemperatureTrait.ID)) {
                    if (!((TemperatureTrait)temperatureTrait).coldEnoughToSnow) continue;
                    cir.setReturnValue((Object)false);
                }
            }
        }
    }

    @Inject(method={"hurtServer(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void setPlayerSource(ServerLevel serverLevel, DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Entity player;
        Mob mobEntity;
        int playerId;
        Entity attacker = source.getEntity();
        if (attacker instanceof Mob && (playerId = ((ShapeDataProvider)(mobEntity = (Mob)attacker)).walkers$shapedPlayer()) != -1 && (player = serverLevel.getEntity(playerId)) instanceof Player) {
            DamageSource damageSource = serverLevel.damageSources().playerAttack((Player)player);
            cir.setReturnValue((Object)this.hurtServer(serverLevel, damageSource, amount));
        }
    }

    @Inject(method={"hurtServer(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="RETURN")})
    private void attackForHealthTrait(ServerLevel serverLevel, DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            boolean didHurtTarget = (Boolean)cir.getReturnValue();
            LivingEntity shape = PlayerShape.getCurrentShape(player);
            if (didHurtTarget && TraitRegistry.has(shape, AttackForHealthTrait.ID)) {
                player.heal(Math.max(1.0f, amount / 2.0f));
            }
        }
    }

    @ModifyArg(method={"setSprinting(Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/attributes/AttributeInstance;addTransientModifier(Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;)V"), index=0)
    private AttributeModifier modifyHorseSprint(AttributeModifier original) {
        Player player;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && PlayerShape.getCurrentShape(player = (Player)livingEntityMixin) instanceof Horse && original.id().equals((Object)SPRINTING_MODIFIER_ID)) {
            return walkers$HORSE_SPRINT_MODIFIER;
        }
        return original;
    }

    static {
        walkers$HORSE_SPRINT_MODIFIER = new AttributeModifier(SPRINTING_MODIFIER_ID, 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }
}

