/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin;

import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.PlayerHostility;
import dev.tocraft.walkers.api.PlayerShape;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinBruteAi;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PiglinBruteAi.class})
public class PiglinBruteBrainMixin {
    @Inject(method={"findNearestValidAttackTarget(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/monster/piglin/AbstractPiglin;)Ljava/util/Optional;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/Brain;getMemory(Lnet/minecraft/world/entity/ai/memory/MemoryModuleType;)Ljava/util/Optional;", ordinal=0)}, cancellable=true)
    private static void getTargetIfWithinRange(ServerLevel serverLevel, AbstractPiglin piglinBrute, CallbackInfoReturnable<Optional<? extends LivingEntity>> cir) {
        cir.setReturnValue(piglinBrute.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER).filter(livingEntity -> {
            Player player;
            LivingEntity shape;
            if (livingEntity instanceof Player && (shape = PlayerShape.getCurrentShape(player = livingEntity)) != null) {
                if (shape instanceof AbstractPiglin) {
                    return false;
                }
                if (Walkers.CONFIG.hostilesIgnoreHostileShapedPlayer && shape instanceof Enemy && !PlayerHostility.hasHostility(player)) {
                    return false;
                }
            }
            return livingEntity.closerThan((Entity)piglinBrute, 12.0);
        }));
    }
}

