/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin;

import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.api.PlayerShapeChanger;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerList.class})
public class PlayerManagerMixin {
    @Inject(method={"respawn(Lnet/minecraft/server/level/ServerPlayer;ZLnet/minecraft/world/entity/Entity$RemovalReason;)Lnet/minecraft/server/level/ServerPlayer;"}, at={@At(value="RETURN")})
    private void onRespawn(ServerPlayer player, boolean bl, Entity.RemovalReason removalReason, CallbackInfoReturnable<ServerPlayer> cir) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)player);
        player.refreshDimensions();
        if (shape != null) {
            if (Walkers.CONFIG.scalingHealth) {
                player.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)Math.min((float)Walkers.CONFIG.maxHealth, shape.getMaxHealth()));
                player.setHealth(player.getMaxHealth());
            }
            if (Walkers.CONFIG.scalingAmor) {
                player.getAttribute(Attributes.ARMOR).setBaseValue(Math.min((double)Walkers.CONFIG.maxAmor, shape.getAttributeBaseValue(Attributes.ARMOR)));
                player.getAttribute(Attributes.ARMOR_TOUGHNESS).setBaseValue(Math.min((double)Walkers.CONFIG.maxAmorToughness, shape.getAttributeBaseValue(Attributes.ARMOR_TOUGHNESS)));
            }
            AttributeInstance playerScaleAttribute = player.getAttribute(Attributes.SCALE);
            AttributeInstance shapeScaleAttribute = shape.getAttribute(Attributes.SCALE);
            if (playerScaleAttribute != null && shapeScaleAttribute != null) {
                shapeScaleAttribute.setBaseValue(playerScaleAttribute.getBaseValue());
            }
            if (Walkers.CONFIG.scalingStepHeight) {
                player.getAttribute(Attributes.STEP_HEIGHT).setBaseValue(shape.getAttributeBaseValue(Attributes.STEP_HEIGHT));
            }
            player.connection.send((Packet)new ClientboundUpdateAttributesPacket(player.getId(), player.getAttributes().getSyncableAttributes()));
        }
        PlayerShapeChanger.sync(player);
        PlayerShape.sync(player);
    }
}

