/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Ravager.class})
public abstract class RavagerEntityMixin
extends LivingEntity {
    private RavagerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    public void travel(Vec3 movementInput) {
        if (this.isAlive()) {
            LivingEntity rider;
            if (this.isVehicle() && (rider = (LivingEntity)this.getFirstPassenger()) instanceof Player) {
                this.setYRot(rider.getYRot());
                this.yRotO = this.getYRot();
                this.setXRot(rider.getXRot() * 0.5f);
                this.setRot(this.getYRot(), this.getXRot());
                this.yHeadRot = this.yBodyRot = this.getYRot();
                float sidewaysSpeed = rider.xxa * 0.5f;
                float forwardSpeed = rider.zza;
                if (forwardSpeed <= 0.0f) {
                    forwardSpeed *= 0.25f;
                }
                if (this.walkers$isControlledByLocalInstance()) {
                    this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
                    super.travel(new Vec3((double)sidewaysSpeed, movementInput.y, (double)forwardSpeed));
                } else if (rider instanceof Player) {
                    this.setDeltaMovement(Vec3.ZERO);
                }
                this.calculateEntityAnimation(false);
                return;
            }
            super.travel(movementInput);
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity rider = this.getFirstPassenger();
        return rider instanceof Player ? (LivingEntity)rider : super.getControllingPassenger();
    }

    @Unique
    private boolean walkers$isControlledByLocalInstance() {
        LivingEntity p = this.getControllingPassenger();
        if (p instanceof Player) {
            Player player = (Player)p;
            return player.isLocalPlayer();
        }
        return this.isEffectiveAi();
    }
}

