/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin;

import com.google.common.collect.ImmutableMap;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.PlayerShape;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.sensing.VillagerHostilesSensor;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={VillagerHostilesSensor.class})
public class VillagerHostilesSensorMixin {
    @Shadow
    @Final
    private static ImmutableMap<EntityType<?>, Float> ACCEPTABLE_DISTANCE_FROM_HOSTILES;

    @Inject(method={"isHostile(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkHostileWalkers(LivingEntity entity, CallbackInfoReturnable<Boolean> cir) {
        if (entity instanceof Player) {
            LivingEntity shape;
            Player player = (Player)entity;
            if (Walkers.CONFIG.villagersRunFrom2ndShapes && (shape = PlayerShape.getCurrentShape(player)) != null && ACCEPTABLE_DISTANCE_FROM_HOSTILES.containsKey((Object)shape.getType())) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"isClose(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkPlayerDanger(LivingEntity villager, LivingEntity potentialPlayer, CallbackInfoReturnable<Boolean> cir) {
        if (potentialPlayer instanceof Player) {
            Player player = (Player)potentialPlayer;
            LivingEntity shape = PlayerShape.getCurrentShape(player);
            if (shape != null && ACCEPTABLE_DISTANCE_FROM_HOSTILES.containsKey((Object)shape.getType())) {
                float f = ((Float)ACCEPTABLE_DISTANCE_FROM_HOSTILES.get((Object)shape.getType())).floatValue();
                cir.setReturnValue((Object)(potentialPlayer.distanceToSqr((Entity)villager) <= (double)(f * f) ? 1 : 0));
            } else {
                cir.setReturnValue((Object)false);
            }
        }
    }
}

