/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import dev.tocraft.walkers.api.PlayerShape;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WitherBoss.class})
public abstract class WitherEntityMixin
extends Monster {
    private WitherEntityMixin(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"customServerAiStep(Lnet/minecraft/server/level/ServerLevel;)V"}, at={@At(value="INVOKE", target="Ljava/util/List;isEmpty()Z")})
    private void removeInvalidPlayerTargets(CallbackInfo ci, @Local @NotNull List<LivingEntity> list) {
        list.removeIf(entity -> {
            Player player;
            LivingEntity shape;
            if (entity instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)entity)) != null && shape.isInvertedHealAndHarm()) {
                if (this.getTarget() != null) {
                    return !this.getTarget().getUUID().equals(entity.getUUID());
                }
                return true;
            }
            return false;
        });
    }
}

