/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin;

import dev.tocraft.walkers.Walkers;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Wolf.class})
public abstract class WolfEntityMixin
extends TamableAnimal {
    @Unique
    private static final ResourceLocation walkers$SPECIAL_WILD = Walkers.id("textures/entity/wolf/special_wild.png");
    @Unique
    private static final ResourceLocation walkers$SPECIAL_TAMED = Walkers.id("textures/entity/wolf/special_tame.png");
    @Unique
    private static final ResourceLocation walkers$SPECIAL_ANGRY = Walkers.id("textures/entity/wolf/special_angry.png");
    @Unique
    private static final EntityDataAccessor<Boolean> walkers$isSpecial = SynchedEntityData.defineId(Wolf.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    private WolfEntityMixin(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    public void onTick(CallbackInfo ci) {
        if (this.hasCustomName()) {
            if (this.getCustomName().getString().equalsIgnoreCase("Patreon")) {
                ((Entity)this).getEntityData().set(walkers$isSpecial, (Object)true);
            } else {
                ((Entity)this).getEntityData().set(walkers$isSpecial, (Object)false);
            }
        }
    }

    @Inject(method={"defineSynchedData(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V"}, at={@At(value="RETURN")})
    protected void onInitDataTracker(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(walkers$isSpecial, (Object)false);
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V"}, at={@At(value="RETURN")})
    protected void onWriteCustomDataToNbt(ValueOutput out, CallbackInfo ci) {
        if (((Boolean)((Entity)this).getEntityData().get(walkers$isSpecial)).booleanValue()) {
            out.putBoolean("isSpecial", true);
        }
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="RETURN")})
    protected void onReadCustomDataFromNbt(ValueInput in, CallbackInfo ci) {
        ((Entity)this).getEntityData().set(walkers$isSpecial, (Object)in.getBooleanOr("isSpecial", false));
    }

    @Inject(method={"getTexture()Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private void setSpecialTexture(CallbackInfoReturnable<ResourceLocation> cir) {
        TagValueOutput out = TagValueOutput.createWithContext((ProblemReporter)Walkers.PROBLEM_REPORTER, (HolderLookup.Provider)this.level().registryAccess());
        this.saveWithoutId((ValueOutput)out);
        CompoundTag nbt = out.buildResult();
        if (nbt.getBooleanOr("isSpecial", false)) {
            if (this.isTame()) {
                cir.setReturnValue((Object)walkers$SPECIAL_TAMED);
            } else {
                cir.setReturnValue((Object)(((Wolf)this).isAngry() ? walkers$SPECIAL_ANGRY : walkers$SPECIAL_WILD));
            }
        }
    }
}

