/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin.client;

import com.mojang.authlib.GameProfile;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.mixin.accessor.LivingEntityAccessor;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LocalPlayer.class})
public abstract class LocalPlayerMixin
extends Player {
    public LocalPlayerMixin(Level level, GameProfile gameProfile) {
        super(level, gameProfile);
    }

    @Inject(method={"jumpableVehicle()Lnet/minecraft/world/entity/PlayerRideableJumping;"}, at={@At(value="RETURN")}, cancellable=true)
    private void shape_jumpable(@NotNull CallbackInfoReturnable<PlayerRideableJumping> cir) {
        LivingEntity shape;
        PlayerRideableJumping r = (PlayerRideableJumping)cir.getReturnValue();
        if (r == null && (shape = PlayerShape.getCurrentShape(this)) instanceof AbstractHorse) {
            AbstractHorse jump = (AbstractHorse)shape;
            cir.setReturnValue((Object)jump);
        }
    }

    @Inject(method={"sendRidingJump()V"}, at={@At(value="HEAD")})
    private void shape_doJump(CallbackInfo ci) {
        LivingEntity shape;
        if (this.onGround() && (shape = PlayerShape.getCurrentShape(this)) instanceof AbstractHorse) {
            float playerJumpPendingScale = 0.4f + 0.4f * (float)Mth.floor((float)(((LocalPlayer)this).getJumpRidingScale() * 100.0f)) / 90.0f;
            double d = ((LivingEntityAccessor)shape).callGetJumpPower(playerJumpPendingScale);
            Vec3 vec3 = this.getDeltaMovement();
            this.setDeltaMovement(vec3.x, d, vec3.z);
            this.hasImpulse = true;
        }
    }

    protected float getJumpPower() {
        return PlayerShape.getCurrentShape(this) instanceof AbstractHorse ? 0.0f : super.getJumpPower();
    }
}

