/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin.client;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.tocraft.craftedcore.util.Maths;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.api.model.ArmRenderingManipulator;
import dev.tocraft.walkers.api.model.EntityArms;
import dev.tocraft.walkers.api.model.EntityUpdater;
import dev.tocraft.walkers.api.model.EntityUpdaters;
import dev.tocraft.walkers.impl.ShapeRenderStateProvider;
import dev.tocraft.walkers.mixin.accessor.EntityAccessor;
import dev.tocraft.walkers.mixin.accessor.LivingEntityAccessor;
import dev.tocraft.walkers.mixin.client.accessor.LimbAnimatorAccessor;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.entity.state.WitherRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={PlayerRenderer.class}, priority=1001)
public abstract class PlayerEntityRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerRenderState, PlayerModel> {
    private PlayerEntityRendererMixin(EntityRendererProvider.Context ctx, PlayerModel model, float shadowRadius) {
        super(ctx, (EntityModel)model, shadowRadius);
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;F)V"}, at={@At(value="RETURN")})
    private void onCreateState(AbstractClientPlayer player, PlayerRenderState state, float f, CallbackInfo ci) {
        ((ShapeRenderStateProvider)state).walkers$setShape(() -> {
            LivingEntity shape = PlayerShape.getCurrentShape((Player)player);
            if (!Minecraft.getInstance().options.getCameraType().isFirstPerson() || player.getVehicle() != Minecraft.getInstance().cameraEntity) {
                if (shape != null) {
                    this.walkers$updateShapeAttributes(player, shape);
                }
                return shape;
            }
            return null;
        });
    }

    @Unique
    private void walkers$updateShapeAttributes(@NotNull PlayerRenderState player, @NotNull EntityRenderState shape) {
        shape.y = player.y;
        shape.x = player.x;
        shape.z = player.z;
        shape.ageInTicks = player.ageInTicks;
        shape.passengerOffset = player.passengerOffset;
        shape.leashStates = player.leashStates;
        if (shape instanceof LivingEntityRenderState) {
            LivingEntityRenderState livingState = (LivingEntityRenderState)shape;
            livingState.pose = player.pose;
            livingState.walkAnimationPos = player.walkAnimationPos;
            livingState.walkAnimationSpeed = player.walkAnimationSpeed;
            livingState.bodyRot = player.bodyRot;
            livingState.xRot = player.xRot;
            livingState.yRot = player.yRot;
            livingState.wornHeadAnimationPos = player.wornHeadAnimationPos;
            livingState.isInWater = player.isInWater;
            livingState.scale = player.scale;
            livingState.isFullyFrozen = player.isFullyFrozen;
            if (livingState instanceof ArmedEntityRenderState) {
                ArmedEntityRenderState armedState = (ArmedEntityRenderState)livingState;
                armedState.mainArm = player.mainArm;
            }
            if (shape instanceof HumanoidRenderState) {
                HumanoidRenderState humanoidShape = (HumanoidRenderState)shape;
                humanoidShape.swimAmount = player.swimAmount;
                humanoidShape.isVisuallySwimming = player.isVisuallySwimming;
                humanoidShape.attackArm = player.attackArm;
                humanoidShape.attackTime = player.attackTime;
                humanoidShape.speedValue = player.speedValue;
                humanoidShape.isCrouching = player.isCrouching;
                humanoidShape.ticksUsingItem = player.ticksUsingItem;
                humanoidShape.isUsingItem = player.isUsingItem;
            } else if (shape instanceof WitherRenderState) {
                WitherRenderState witherState = (WitherRenderState)shape;
                witherState.xHeadRots = new float[]{player.xRot, player.xRot};
                witherState.yHeadRots = new float[]{player.bodyRot + player.yRot, player.bodyRot + player.yRot};
            }
        }
    }

    @Unique
    private void walkers$updateShapeAttributes(@NotNull AbstractClientPlayer player, @NotNull LivingEntity shape) {
        ((LimbAnimatorAccessor)shape.walkAnimation).setPrevSpeed(((LimbAnimatorAccessor)player.walkAnimation).getPrevSpeed());
        shape.walkAnimation.setSpeed(player.walkAnimation.speed());
        ((LimbAnimatorAccessor)shape.walkAnimation).setPos(player.walkAnimation.position());
        shape.swinging = player.swinging;
        shape.swingTime = player.swingTime;
        shape.oAttackAnim = player.oAttackAnim;
        shape.attackAnim = player.attackAnim;
        shape.yBodyRot = player.yBodyRot;
        shape.yBodyRotO = player.yBodyRotO;
        shape.yHeadRot = player.yHeadRot;
        shape.yHeadRotO = player.yHeadRotO;
        shape.tickCount = player.tickCount;
        shape.swingingArm = player.swingingArm;
        ((LivingEntityAccessor)shape).setSwimAmount(((LivingEntityAccessor)player).getSwimAmount());
        ((LivingEntityAccessor)shape).setSwimAmountO(((LivingEntityAccessor)player).getSwimAmountO());
        shape.setOnGround(player.onGround());
        shape.setDeltaMovement(player.getDeltaMovement());
        if (Minecraft.getInstance().player != null) {
            shape.setInvisible(player.isInvisibleTo((Player)Minecraft.getInstance().player));
        }
        ((EntityAccessor)shape).setVehicle(player.getVehicle());
        ((EntityAccessor)shape).setPassengers((ImmutableList<Entity>)ImmutableList.copyOf((Collection)player.getPassengers()));
        ((EntityAccessor)shape).setTouchingWater(player.isInWater());
        if (shape instanceof Phantom) {
            shape.setXRot(-player.getXRot());
            shape.xRotO = -player.xRotO;
        } else {
            shape.setXRot(player.getXRot());
            shape.xRotO = player.xRotO;
        }
        if (Walkers.CONFIG.shapesEquipItems) {
            shape.setItemSlot(EquipmentSlot.MAINHAND, player.getItemBySlot(EquipmentSlot.MAINHAND));
            shape.setItemSlot(EquipmentSlot.OFFHAND, player.getItemBySlot(EquipmentSlot.OFFHAND));
        }
        if (Walkers.CONFIG.shapesEquipArmor) {
            shape.setItemSlot(EquipmentSlot.HEAD, player.getItemBySlot(EquipmentSlot.HEAD));
            shape.setItemSlot(EquipmentSlot.CHEST, player.getItemBySlot(EquipmentSlot.CHEST));
            shape.setItemSlot(EquipmentSlot.LEGS, player.getItemBySlot(EquipmentSlot.LEGS));
            shape.setItemSlot(EquipmentSlot.FEET, player.getItemBySlot(EquipmentSlot.FEET));
        }
        if (shape instanceof Mob) {
            ((Mob)shape).setAggressive(player.isUsingItem());
        }
        shape.setPose(player.getPose());
        shape.startUsingItem(player.getUsedItemHand() == null ? InteractionHand.MAIN_HAND : player.getUsedItemHand());
        ((LivingEntityAccessor)shape).callSetLivingEntityFlag(1, player.isUsingItem());
        shape.getTicksUsingItem();
        ((LivingEntityAccessor)shape).callUpdatingUsingItem();
        shape.hurtTime = player.hurtTime;
        EntityUpdater entityUpdater = EntityUpdaters.getUpdater(shape.getType());
        if (entityUpdater != null) {
            entityUpdater.update((Player)player, shape);
        }
        if (player != Minecraft.getInstance().player && PlayerEntityRendererMixin.walkers$showName(player)) {
            shape.setCustomName(player.getCustomName());
        }
    }

    @Unique
    private static boolean walkers$showName(@NotNull AbstractClientPlayer player) {
        PlayerTeam team = player.getTeam();
        boolean showName = Walkers.CONFIG.showPlayerNametag;
        if (showName && team != null) {
            Team.Visibility visibility = team.getNameTagVisibility();
            PlayerTeam localTeam = Minecraft.getInstance().player.getTeam();
            boolean sameTeam = Objects.equals(localTeam != null ? localTeam.getName() : null, team.getName());
            if (visibility == Team.Visibility.NEVER || sameTeam && visibility == Team.Visibility.HIDE_FOR_OWN_TEAM || !sameTeam && visibility == Team.Visibility.HIDE_FOR_OTHER_TEAMS) {
                showName = false;
            }
        }
        return showName;
    }

    public void render(PlayerRenderState state, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        LivingEntity shape = ((ShapeRenderStateProvider)state).walkers$getShape();
        if (shape != null && !state.isSpectator) {
            if (!state.isInvisibleToPlayer && !state.isInvisible) {
                EntityRenderer shapeRenderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)shape);
                EntityRenderState shapeState = shapeRenderer.createRenderState((Entity)shape, (float)packedLight);
                this.walkers$updateShapeAttributes(state, shapeState);
                shapeRenderer.render(shapeState, matrixStack, buffer, packedLight);
            }
            return;
        }
        super.render((LivingEntityRenderState)state, matrixStack, buffer, packedLight);
    }

    @Inject(method={"getRenderOffset(Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyPositionOffset(PlayerRenderState state, CallbackInfoReturnable<Vec3> cir) {
        LivingEntity shape = ((ShapeRenderStateProvider)state).walkers$getShape();
        if (shape != null && shape instanceof TamableAnimal) {
            cir.setReturnValue((Object)super.getRenderOffset((EntityRenderState)state));
        }
    }

    @Inject(method={"renderHand(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/resources/ResourceLocation;Lnet/minecraft/client/model/geom/ModelPart;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderArm(PoseStack matrices, MultiBufferSource vertexConsumers, int light, ResourceLocation resourceLocation, ModelPart arm, boolean bl, CallbackInfo ci) {
        EntityRenderer renderer;
        Player player;
        LivingEntity shape;
        Entity entity = Minecraft.getInstance().cameraEntity;
        if (entity instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)entity)) != null && (renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)shape)) instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            LivingEntityRenderState shapeState = (LivingEntityRenderState)livingRenderer.createRenderState((Entity)shape, (float)light);
            ResourceLocation texture = livingRenderer.getTextureLocation(shapeState);
            EntityModel model = livingRenderer.getModel();
            arm = null;
            if (model instanceof HumanoidModel) {
                arm = player.getMainArm() == HumanoidArm.RIGHT ? ((HumanoidModel)model).rightArm : ((HumanoidModel)model).leftArm;
            } else {
                Tuple<ModelPart, ArmRenderingManipulator<?>> pair = EntityArms.get(shape, model);
                if (pair != null) {
                    arm = (ModelPart)pair.getA();
                    if (player.getMainArm() == HumanoidArm.LEFT) {
                        matrices.mulPose((Quaternionfc)Maths.getDegreesQuaternion((Vector3f)Maths.POSITIVE_Y(), (float)180.0f));
                    }
                    ((ArmRenderingManipulator)pair.getB()).run(matrices, model);
                    matrices.translate(0.0, -0.35, 0.5);
                }
            }
            model.setupAnim(renderer.createRenderState((Entity)shape, (float)light));
            if (arm != null) {
                arm.xRot = 0.0f;
                arm.render(matrices, vertexConsumers.getBuffer(RenderType.entityTranslucent((ResourceLocation)texture)), light, OverlayTexture.NO_OVERLAY);
            }
            ci.cancel();
        }
    }
}

