/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin.player;

import dev.tocraft.walkers.api.PlayerShape;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityAttackMixin
extends LivingEntity {
    private PlayerEntityAttackMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;skipAttackInteraction(Lnet/minecraft/world/entity/Entity;)Z")}, cancellable=true)
    private void shapeAttack(Entity target, CallbackInfo ci) {
        Level level;
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (shape != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getMainHandItem().isEmpty()) {
                try {
                    shape.doHurtTarget(serverLevel, target);
                    ci.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

