/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin.player;

import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.FlightHelper;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.api.variant.ShapeType;
import dev.tocraft.walkers.impl.PlayerDataProvider;
import dev.tocraft.walkers.mixin.EntityTrackerAccessor;
import dev.tocraft.walkers.mixin.ThreadedAnvilChunkStorageAccessor;
import dev.tocraft.walkers.traits.TraitRegistry;
import dev.tocraft.walkers.traits.impl.RiderTrait;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityDataMixin
extends LivingEntity
implements PlayerDataProvider {
    @Unique
    private static final String ABILITY_COOLDOWN_KEY = "AbilityCooldown";
    @Unique
    @Nullable
    private ShapeType<?> walkers$unlocked;
    @Unique
    private int walkers$remainingTime = 0;
    @Unique
    private int walkers$abilityCooldown = 0;
    @Unique
    @Nullable
    private LivingEntity walkers$shape = null;
    @Unique
    private float walkers$normalHealth = -1.0f;

    private PlayerEntityDataMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="RETURN")})
    private void readNbt(ValueInput in, CallbackInfo ci) {
        ValueInput unlockedShape = in.childOrEmpty("UnlockedShape");
        this.walkers$unlocked = ShapeType.from(unlockedShape);
        this.walkers$abilityCooldown = in.getInt(ABILITY_COOLDOWN_KEY).orElse(0);
        this.walkers$remainingTime = in.getInt("RemainingHostilityTime").orElse(0);
        this.walkers$normalHealth = in.getFloatOr("walkersHealth", -1.0f);
        this.walkers$readCurrentShape(in.childOrEmpty("CurrentShape"));
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V"}, at={@At(value="RETURN")})
    private void writeNbt(ValueOutput out, CallbackInfo ci) {
        CompoundTag id = new CompoundTag();
        if (this.walkers$unlocked != null) {
            id = this.walkers$unlocked.writeCompound();
        }
        out.store("UnlockedShape", CompoundTag.CODEC, (Object)id);
        out.putInt(ABILITY_COOLDOWN_KEY, this.walkers$abilityCooldown);
        out.putInt("RemainingHostilityTime", this.walkers$remainingTime);
        out.putFloat("walkersHealth", this.walkers$normalHealth);
        this.walkers$writeCurrentShape(out.child("CurrentShape"));
    }

    @Unique
    private void walkers$writeCurrentShape(@NotNull ValueOutput out) {
        ValueOutput shapeOut = out.child("EntityData");
        if (this.walkers$shape != null) {
            this.walkers$shape.saveWithoutId(shapeOut);
        }
        out.putString("id", this.walkers$shape == null ? "minecraft:empty" : EntityType.getKey((EntityType)this.walkers$shape.getType()).toString());
    }

    @Unique
    public void walkers$readCurrentShape(ValueInput in) {
        Optional entityTag;
        Optional type = EntityType.by((ValueInput)in);
        if (in.getString("id").map(it -> it.equals("minecraft:empty")).orElse(false).booleanValue()) {
            this.walkers$shape = null;
            this.refreshDimensions();
        } else if (type.isPresent() && (entityTag = in.child("EntityData")).isPresent()) {
            if (this.walkers$shape == null || !((EntityType)type.get()).equals(this.walkers$shape.getType())) {
                this.walkers$shape = (LivingEntity)((EntityType)type.get()).create(this.level(), EntitySpawnReason.LOAD);
                this.refreshDimensions();
            }
            if (this.walkers$shape != null) {
                this.walkers$shape.load((ValueInput)entityTag.get());
            }
        }
    }

    @Override
    @Unique
    @Nullable
    public ShapeType<?> walkers$get2ndShape() {
        return this.walkers$unlocked;
    }

    @Override
    public void walkers$set2ndShape(ShapeType<?> unlocked) {
        this.walkers$unlocked = unlocked;
    }

    @Override
    @Unique
    public int walkers$getRemainingHostilityTime() {
        return this.walkers$remainingTime;
    }

    @Override
    @Unique
    public void walkers$setRemainingHostilityTime(int max) {
        this.walkers$remainingTime = max;
    }

    @Override
    @Unique
    public int walkers$getAbilityCooldown() {
        return this.walkers$abilityCooldown;
    }

    @Override
    @Unique
    public void walkers$setAbilityCooldown(int abilityCooldown) {
        this.walkers$abilityCooldown = abilityCooldown;
    }

    @Override
    @Unique
    @Nullable
    public LivingEntity walkers$getCurrentShape() {
        return this.walkers$shape;
    }

    @Override
    @Unique
    public void walkers$setCurrentShape(LivingEntity shape) {
        this.walkers$shape = shape;
    }

    @Override
    @Unique
    public void walkers$updateShapes(@Nullable LivingEntity shape) {
        Entity playerStepHeightAttr;
        Level level;
        Player player = (Player)this;
        AttributeInstance healthAttribute = player.getAttribute(Attributes.MAX_HEALTH);
        AttributeInstance armorAttribute = player.getAttribute(Attributes.ARMOR);
        AttributeInstance armorToughnessAttribute = player.getAttribute(Attributes.ARMOR_TOUGHNESS);
        if (Walkers.CONFIG.emit_particles && this.walkers$shape != shape && (level = player.level()) instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            l.sendParticles((ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, player.getX(), player.getY() + 1.0, player.getZ(), 25, 0.5, 1.0, 0.5, 0.5);
            l.sendParticles((ParticleOptions)ParticleTypes.PORTAL, player.getX(), player.getY() + 1.0, player.getZ(), 25, 0.5, 1.0, 0.5, 0.5);
            l.sendParticles((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, player.getX(), player.getY() + 1.0, player.getZ(), 25, 0.5, 1.0, 0.5, 0.5);
        }
        this.walkers$shape = shape;
        if (shape != null) {
            if (Walkers.CONFIG.scalingHealth && healthAttribute != null) {
                this.walkers$normalHealth = player.getMaxHealth();
                float currentHealthPercent = player.getHealth() / player.getMaxHealth();
                healthAttribute.setBaseValue((double)Math.min((float)Walkers.CONFIG.maxHealth, shape.getMaxHealth()));
                if (Walkers.CONFIG.percentScalingHealth) {
                    player.setHealth(Math.min(currentHealthPercent * player.getMaxHealth(), player.getMaxHealth()));
                } else {
                    player.setHealth(Math.min(player.getHealth(), player.getMaxHealth()));
                }
            }
            if (Walkers.CONFIG.scalingAmor) {
                AttributeInstance shapeArmorAttribute = shape.getAttribute(Attributes.ARMOR);
                if (armorAttribute != null && shapeArmorAttribute != null) {
                    armorAttribute.setBaseValue(Math.min((double)Walkers.CONFIG.maxAmor, shapeArmorAttribute.getBaseValue()));
                }
                AttributeInstance shapeArmorToughnessAttribute = shape.getAttribute(Attributes.ARMOR_TOUGHNESS);
                if (armorToughnessAttribute != null && shapeArmorToughnessAttribute != null) {
                    armorToughnessAttribute.setBaseValue(Math.min((double)Walkers.CONFIG.maxAmorToughness, shapeArmorToughnessAttribute.getBaseValue()));
                }
            }
            AttributeInstance playerScaleAttribute = player.getAttribute(Attributes.SCALE);
            AttributeInstance shapeScaleAttribute = shape.getAttribute(Attributes.SCALE);
            if (playerScaleAttribute != null && shapeScaleAttribute != null) {
                shapeScaleAttribute.setBaseValue(playerScaleAttribute.getBaseValue());
            }
            if (Walkers.CONFIG.scalingStepHeight && (playerStepHeightAttr = player.getAttribute(Attributes.STEP_HEIGHT)) != null) {
                playerStepHeightAttr.setBaseValue((double)shape.maxUpStep());
            }
        }
        player.refreshDimensions();
        if (shape == null) {
            AttributeInstance playerStepHeightAttr2;
            if (Walkers.CONFIG.scalingHealth && healthAttribute != null) {
                float currentHealthPercent = player.getHealth() / player.getMaxHealth();
                float health = Walkers.CONFIG.player_health;
                if (health < 0.0f) {
                    health = this.walkers$normalHealth > 0.0f ? this.walkers$normalHealth : 20.0f;
                }
                healthAttribute.setBaseValue((double)health);
                if (Walkers.CONFIG.percentScalingHealth) {
                    player.setHealth(Math.min(currentHealthPercent * player.getMaxHealth(), player.getMaxHealth()));
                } else {
                    player.setHealth(Math.min(player.getHealth(), player.getMaxHealth()));
                }
            }
            if (Walkers.CONFIG.scalingAmor) {
                if (armorAttribute != null) {
                    armorAttribute.setBaseValue(0.0);
                }
                if (armorToughnessAttribute != null) {
                    armorAttribute.setBaseValue(0.0);
                }
            }
            if (Walkers.CONFIG.scalingStepHeight && (playerStepHeightAttr2 = player.getAttribute(Attributes.STEP_HEIGHT)) != null) {
                playerStepHeightAttr2.setBaseValue(0.6);
            }
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (Walkers.hasFlyingPermissions((ServerPlayer)player)) {
            FlightHelper.grantFlightTo(serverPlayer);
            FlightHelper.updateFlyingSpeed(player);
            player.onUpdateAbilities();
        } else if (!player.isCreative()) {
            FlightHelper.revokeFlight(serverPlayer);
            player.getAbilities().setFlyingSpeed(0.05f);
            player.onUpdateAbilities();
        }
        playerStepHeightAttr = player.getVehicle();
        if (playerStepHeightAttr instanceof LivingEntity) {
            LivingEntity livingVehicle = (LivingEntity)playerStepHeightAttr;
            boolean b1 = false;
            boolean b2 = false;
            for (RiderTrait riderTrait : TraitRegistry.get(shape, RiderTrait.ID).stream().map(entry -> (RiderTrait)entry).toList()) {
                Player rideablePlayer;
                if (riderTrait.isRideable(livingVehicle) || livingVehicle instanceof Player && riderTrait.isRideable(PlayerShape.getCurrentShape(rideablePlayer = (Player)livingVehicle))) {
                    b1 = true;
                    b2 = true;
                }
                if (!b2) continue;
                break;
            }
            if (!b1) {
                player.stopRiding();
            }
        }
        if (!(shape instanceof AbstractHorse)) {
            for (Entity passenger : player.getPassengers()) {
                passenger.stopRiding();
            }
        }
        if (!player.level().isClientSide) {
            PlayerShape.sync((ServerPlayer)player);
            Int2ObjectMap<Object> trackers = ((ThreadedAnvilChunkStorageAccessor)((ServerLevel)player.level()).getChunkSource().chunkMap).getEntityMap();
            Object tracking = trackers.get(player.getId());
            ((EntityTrackerAccessor)tracking).getSeenBy().forEach(listener -> PlayerShape.sync((ServerPlayer)player, listener.getPlayer()));
        }
    }
}

