/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin.player;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.mixin.LivingEntityMixin;
import dev.tocraft.walkers.mixin.accessor.EntityAccessor;
import dev.tocraft.walkers.mixin.accessor.IronGolemEntityAccessor;
import dev.tocraft.walkers.mixin.accessor.LivingEntityAccessor;
import dev.tocraft.walkers.mixin.accessor.RavagerEntityAccessor;
import dev.tocraft.walkers.traits.ShapeTrait;
import dev.tocraft.walkers.traits.TraitRegistry;
import dev.tocraft.walkers.traits.impl.AttackForHealthTrait;
import dev.tocraft.walkers.traits.impl.BurnInDaylightTrait;
import dev.tocraft.walkers.traits.impl.HumanoidTrait;
import dev.tocraft.walkers.traits.impl.InstantDieOnDamageMsgTrait;
import dev.tocraft.walkers.traits.impl.InvulnerabilityTrait;
import dev.tocraft.walkers.traits.impl.ReinforcementsTrait;
import dev.tocraft.walkers.traits.impl.TemperatureTrait;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntityMixin {
    private PlayerEntityMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Inject(method={"getDefaultDimensions(Lnet/minecraft/world/entity/Pose;)Lnet/minecraft/world/entity/EntityDimensions;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getDimensions(Pose pose, CallbackInfoReturnable<EntityDimensions> cir) {
        LivingEntity entity = PlayerShape.getCurrentShape((Player)this);
        if (!(entity == null || pose == Pose.CROUCHING && TraitRegistry.has(entity, HumanoidTrait.ID))) {
            EntityDimensions shapeDimensions = entity.getDimensions(pose);
            cir.setReturnValue((Object)shapeDimensions);
        }
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")})
    protected void shape_tryAttack(Entity target, CallbackInfo ci) {
        Bee bee;
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (shape instanceof IronGolem) {
            IronGolem golem = (IronGolem)shape;
            ((IronGolemEntityAccessor)golem).setAttackTicksLeft(10);
        } else if (shape instanceof Warden) {
            Warden warden = (Warden)shape;
            warden.attackAnimationState.start(this.tickCount);
        } else if (shape instanceof Ravager) {
            Ravager ravager = (Ravager)shape;
            ((RavagerEntityAccessor)ravager).setAttackTick(10);
        } else if (shape instanceof WitherSkeleton && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            livingTarget.addEffect(new MobEffectInstance(MobEffects.WITHER, 200), (Entity)this);
        } else if (shape instanceof Bee && (bee = (Bee)shape).isAngry() && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            livingTarget.addEffect(new MobEffectInstance(MobEffects.POISON, 200), (Entity)this);
        } else if (shape instanceof Pufferfish) {
            Pufferfish pufferfish = (Pufferfish)shape;
            if (!this.level().isClientSide) {
                LivingEntity livingTarget;
                int i = pufferfish.getPuffState();
                if (target instanceof LivingEntity && (livingTarget = (LivingEntity)target).hurtServer((ServerLevel)this.level(), this.damageSources().mobAttack((LivingEntity)((Player)this)), (float)(1 + i))) {
                    livingTarget.addEffect(new MobEffectInstance(MobEffects.POISON, 60 * i, 0), (Entity)((Player)this));
                    this.playSound(SoundEvents.PUFFER_FISH_STING, 1.0f, 1.0f);
                    if (livingTarget instanceof ServerPlayer) {
                        ServerPlayer serverPlayerTarget = (ServerPlayer)livingTarget;
                        if (!this.isSilent()) {
                            serverPlayerTarget.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.PUFFER_FISH_STING, 0.0f));
                        }
                    }
                }
            }
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tickGolemAttackTicks(CallbackInfo ci) {
        IronGolem golem;
        IronGolemEntityAccessor accessor;
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (shape instanceof IronGolem && (accessor = (IronGolemEntityAccessor)(golem = (IronGolem)shape)).getAttackTicksLeft() > 0) {
            accessor.setAttackTicksLeft(accessor.getAttackTicksLeft() - 1);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tickRavagerAttackTicks(CallbackInfo ci) {
        Ravager ravager;
        RavagerEntityAccessor accessor;
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (shape instanceof Ravager && (accessor = (RavagerEntityAccessor)(ravager = (Ravager)shape)).getAttackTick() > 0) {
            accessor.setAttackTick(accessor.getAttackTick() - 1);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tickWardenSneakingAnimation(CallbackInfo ci) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (shape instanceof Warden) {
            Warden warden = (Warden)shape;
            if (this.isShiftKeyDown()) {
                if (!warden.sniffAnimationState.isStarted()) {
                    warden.sniffAnimationState.start(this.tickCount);
                }
            } else {
                warden.sniffAnimationState.stop();
            }
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tickFire(CallbackInfo ci) {
        Player player = (Player)this;
        LivingEntity shape = PlayerShape.getCurrentShape(player);
        if (!player.level().isClientSide && !player.isCreative() && !player.isSpectator() && shape != null && TraitRegistry.has(shape, BurnInDaylightTrait.ID)) {
            boolean bl = this.walkers$isInDaylight();
            for (BurnInDaylightTrait trait2 : TraitRegistry.get(shape, BurnInDaylightTrait.ID).stream().map(trait -> (BurnInDaylightTrait)trait).toList()) {
                bl = bl && !trait2.burnInMoonlightInstead || !this.walkers$isInDaylight() && trait2.burnInMoonlightInstead;
            }
            if (bl) {
                if (player.level().isRaining()) {
                    return;
                }
                ItemStack itemStack = player.getItemBySlot(EquipmentSlot.HEAD);
                if (!itemStack.isEmpty()) {
                    if (itemStack.isDamageableItem()) {
                        itemStack.setDamageValue(itemStack.getDamageValue() + player.getRandom().nextInt(2));
                        if (itemStack.getDamageValue() >= itemStack.getMaxDamage()) {
                            player.onEquippedItemBroken(itemStack.getItem(), EquipmentSlot.HEAD);
                            player.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
                        }
                    }
                    bl = false;
                }
                if (bl) {
                    player.igniteForSeconds(8.0f);
                }
            }
        }
    }

    @Unique
    private boolean walkers$isInDaylight() {
        if (!this.level().isClientSide && !this.level().dimensionType().hasFixedTime() && this.level().getSkyDarken() < 4) {
            float brightnessAtEyes = this.getLightLevelDependentMagicValue();
            BlockPos daylightTestPosition = BlockPos.containing((double)this.getX(), (double)Math.round(this.getY()), (double)this.getZ());
            if (this.getVehicle() instanceof Boat) {
                daylightTestPosition = daylightTestPosition.above();
            }
            return brightnessAtEyes > 0.5f && this.random.nextFloat() * 30.0f < (brightnessAtEyes - 0.4f) * 2.0f && this.level().canSeeSky(daylightTestPosition);
        }
        return false;
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tickTemperature(CallbackInfo ci) {
        Player player = (Player)this;
        LivingEntity shape = PlayerShape.getCurrentShape(player);
        if (!player.isCreative() && !player.isSpectator() && shape != null) {
            boolean couldEnoughToSnow = ((Biome)this.level().getBiome(this.blockPosition()).value()).coldEnoughToSnow(this.blockPosition(), this.level().getSeaLevel());
            for (TemperatureTrait temperaturetrait : TraitRegistry.get(shape, TemperatureTrait.ID).stream().map(entry -> (TemperatureTrait)entry).toList()) {
                if (!temperaturetrait.coldEnoughToSnow != couldEnoughToSnow) continue;
                player.hurt(this.level().damageSources().onFire(), 1.0f);
                break;
            }
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tickWalkers(CallbackInfo ci) {
        Player player = (Player)this;
        LivingEntity shape = PlayerShape.getCurrentShape(player);
        if (shape != null) {
            shape.setShiftKeyDown(player.isShiftKeyDown());
            shape.setPose(player.getPose());
            shape.setSwimming(player.isSwimming());
            if (!this.level().isClientSide) {
                shape.setPosRaw(player.getX(), player.getY(), player.getZ());
                shape.setYHeadRot(player.getYHeadRot());
                shape.setJumping(((LivingEntityAccessor)player).isJumping());
                shape.setSprinting(player.isSprinting());
                shape.setArrowCount(player.getArrowCount());
                shape.setInvulnerable(true);
                shape.setNoGravity(true);
                shape.setSwimming(player.isSwimming());
                shape.startUsingItem(player.getUsedItemHand());
                if (shape instanceof TamableAnimal) {
                    ((TamableAnimal)shape).setInSittingPose(player.isShiftKeyDown());
                    ((TamableAnimal)shape).setOrderedToSit(player.isShiftKeyDown());
                } else if (shape instanceof Fox) {
                    ((Fox)shape).setSitting(player.isShiftKeyDown());
                    ((Fox)shape).setJumping(!player.onGround());
                }
                ((EntityAccessor)shape).shape_callSetFlag(7, player.isFallFlying());
                ((LivingEntityAccessor)shape).callUpdatingUsingItem();
                PlayerShape.sync((ServerPlayer)player);
            }
        }
    }

    @Inject(method={"makeStuckInBlock(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onStuckInBlock(BlockState state, Vec3 motionMultiplier, CallbackInfo ci) {
        if (PlayerShape.getCurrentShape((Player)this) instanceof Spider && state.is(Blocks.COBWEB)) {
            ci.cancel();
        }
    }

    @Inject(method={"touch(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")})
    private void onTouch(Entity entity, CallbackInfo ci) {
        LivingEntity livingEntity;
        Player ownPlayer = (Player)this;
        if (!this.level().isClientSide && ownPlayer.isAlive() && (livingEntity = PlayerShape.getCurrentShape(ownPlayer)) instanceof Slime) {
            Player targetPlayer;
            Slime slimeShape = (Slime)livingEntity;
            if (entity instanceof Player && !(PlayerShape.getCurrentShape(targetPlayer = (Player)entity) instanceof Slime)) {
                int i = slimeShape.getSize();
                boolean wasHurt = targetPlayer.hurtServer((ServerLevel)this.level(), ownPlayer.damageSources().mobAttack((LivingEntity)ownPlayer), (float)ownPlayer.getAttributeValue(Attributes.ATTACK_DAMAGE));
                if (this.distanceToSqr((Entity)targetPlayer) < 0.6 * (double)i * 0.6 * (double)i && ownPlayer.hasLineOfSight((Entity)targetPlayer) && wasHurt) {
                    this.playSound(SoundEvents.SLIME_ATTACK, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                    EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)ownPlayer.level()), (Entity)targetPlayer, (DamageSource)ownPlayer.damageSources().mobAttack((LivingEntity)ownPlayer));
                }
            }
        }
    }

    @Inject(method={"hurtServer(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="HEAD")})
    private void handeReinforcementsTrait(ServerLevel level, DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Player player = (Player)this;
        LivingEntity shape = PlayerShape.getCurrentShape(player);
        Object object = source.getEntity();
        if (object instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)object;
            if (shape != null && (object = TraitRegistry.get(shape, ReinforcementsTrait.ID).stream().map(trait -> (ReinforcementsTrait)trait).toList().iterator()).hasNext()) {
                ReinforcementsTrait reinforcementTrait = (ReinforcementsTrait)object.next();
                double d = reinforcementTrait.getRange();
                AABB aABB = AABB.unitCubeFromLowerCorner((Vec3)this.position()).inflate(d, 10.0, d);
                Iterator var5 = level.getEntitiesOfClass(Mob.class, aABB, EntitySelector.NO_SPECTATORS.and(entity -> {
                    if (reinforcementTrait.hasReinforcements()) {
                        return reinforcementTrait.isReinforcement((Entity)entity);
                    }
                    return shape.getClass().isInstance(entity);
                })).iterator();
                while (true) {
                    boolean bl;
                    if (!var5.hasNext()) {
                        return;
                    }
                    Mob mob = (Mob)var5.next();
                    if (shape == mob || mob.getTarget() != null || (bl = false)) continue;
                    mob.setTarget(livingAttacker);
                }
            }
        }
    }

    @Inject(method={"hurtServer(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="HEAD")})
    private void instantDieOnDamageTypeTrait(ServerLevel level, DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (shape != null) {
            for (ShapeTrait<LivingEntity> instantDieOnDamageTypetrait : TraitRegistry.get(shape, InstantDieOnDamageMsgTrait.ID)) {
                if (!source.getMsgId().equals(((InstantDieOnDamageMsgTrait)instantDieOnDamageTypetrait).msgId)) continue;
                this.kill(level);
            }
        }
    }

    @Inject(method={"isInvulnerableTo(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void invulnerabilityTrait(ServerLevel level, DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (!damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && TraitRegistry.has(shape, InvulnerabilityTrait.ID)) {
            cir.setReturnValue((Object)true);
        }
    }

    @WrapWithCondition(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;tick(Lnet/minecraft/server/level/ServerPlayer;)V")})
    private boolean preventFoodDataTick(FoodData instance, ServerPlayer player) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)player);
        return player.hasEffect(MobEffects.SATURATION) || !TraitRegistry.has(shape, AttackForHealthTrait.ID);
    }

    @Inject(method={"canEat(Z)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void onCanEat(boolean canAlwaysEat, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue() && TraitRegistry.has(PlayerShape.getCurrentShape((Player)this), AttackForHealthTrait.ID)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"causeFoodExhaustion(F)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onExhaustion(float exhaustion, CallbackInfo ci) {
        if (TraitRegistry.has(PlayerShape.getCurrentShape((Player)this), AttackForHealthTrait.ID)) {
            ci.cancel();
        }
    }
}

