/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin.player;

import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.impl.SonicBoomUser;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerSonicBoomMixin
extends LivingEntity
implements SonicBoomUser {
    @Unique
    private int shape$ability_wardenBoomDelay = -1;

    private PlayerSonicBoomMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Override
    public void shape$ability_startSonicBoom() {
        @Nullable LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (shape instanceof Warden) {
            this.level().broadcastEntityEvent((Entity)this, (byte)62);
            this.shape$ability_wardenBoomDelay = 40;
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WARDEN_SONIC_CHARGE, SoundSource.PLAYERS, 3.0f, 1.0f);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tickSonicBoom(CallbackInfo ci) {
        if (!this.level().isClientSide) {
            this.shape$ability_wardenBoomDelay = Math.max(-1, this.shape$ability_wardenBoomDelay - 1);
            if (this.shape$ability_wardenBoomDelay == 0) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WARDEN_SONIC_BOOM, SoundSource.PLAYERS, 3.0f, 1.0f);
                float heightOffset = 1.6f;
                int distance = 16;
                Vec3 target = this.position().add(this.getLookAngle().scale((double)distance));
                Vec3 source = this.position().add(0.0, (double)heightOffset, 0.0);
                Vec3 offsetToTarget = target.subtract(source);
                Vec3 normalized = offsetToTarget.normalize();
                HashSet hit = new HashSet();
                for (int particleIndex = 1; particleIndex < Mth.floor((double)offsetToTarget.length()) + 7; ++particleIndex) {
                    Vec3 particlePos = source.add(normalized.scale((double)particleIndex));
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, particlePos.x, particlePos.y, particlePos.z, 1, 0.0, 0.0, 0.0, 0.0);
                    hit.addAll(this.level().getEntitiesOfClass(LivingEntity.class, new AABB(BlockPos.containing((double)particlePos.x(), (double)particlePos.y(), (double)particlePos.z())).inflate(2.0), it -> !(it instanceof Wolf)));
                }
                hit.remove((Player)this);
                for (Entity hitTarget : hit) {
                    if (!(hitTarget instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)hitTarget;
                    living.hurt(this.level().damageSources().sonicBoom((Entity)((Player)this)), 10.0f);
                    double vertical = 0.5 * (1.0 - living.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                    double horizontal = 2.5 * (1.0 - living.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                    living.push(normalized.x() * horizontal, normalized.y() * vertical, normalized.z() * horizontal);
                }
            }
        }
    }
}

