/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.network;

import dev.tocraft.craftedcore.client.CraftedCoreClient;
import dev.tocraft.craftedcore.network.ModernNetworking;
import dev.tocraft.craftedcore.network.client.ClientNetworking;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.impl.PlayerDataProvider;
import dev.tocraft.walkers.network.NetworkHandler;
import dev.tocraft.walkers.network.impl.SyncApiLevelPackets;
import dev.tocraft.walkers.network.impl.UnlockPackets;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.jetbrains.annotations.Nullable;

public class ClientNetworking
implements NetworkHandler {
    public static void registerPacketHandlers() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (ResourceLocation)NetworkHandler.SHAPE_SYNC, ClientNetworking::handleWalkersSyncPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (ResourceLocation)NetworkHandler.ABILITY_SYNC, ClientNetworking::handleAbilitySyncPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (ResourceLocation)NetworkHandler.UNLOCK_SYNC, UnlockPackets::handleUnlockSyncPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (ResourceLocation)NetworkHandler.SYNC_API_LEVEL, (context, nbt) -> SyncApiLevelPackets.handleSyncPacket(nbt));
    }

    public static void runOrQueue(ModernNetworking.Context context, ClientNetworking.ApplicablePacket packet) {
        if (context.getPlayer() == null) {
            CraftedCoreClient.getSyncPacketQueue().add(packet);
        } else {
            context.queue(() -> packet.apply(context.getPlayer()));
        }
    }

    public static void sendAbilityRequest() {
        ModernNetworking.sendToServer((ResourceLocation)USE_ABILITY, (CompoundTag)new CompoundTag());
    }

    public static void handleWalkersSyncPacket(ModernNetworking.Context context, CompoundTag packetData) {
        UUID uuid = UUIDUtil.uuidFromIntArray((int[])((int[])packetData.getIntArray("uuid").orElseThrow()));
        String id = (String)packetData.getString("type").orElseThrow();
        CompoundTag entityNbt = (CompoundTag)packetData.getCompound("entity_tag").orElseThrow();
        ClientNetworking.runOrQueue(context, player -> {
            @Nullable Player syncTarget = player.level().getPlayerByUUID(uuid);
            if (syncTarget != null) {
                PlayerDataProvider data = (PlayerDataProvider)syncTarget;
                if (id.equals("minecraft:empty")) {
                    data.walkers$setCurrentShape(null);
                    syncTarget.refreshDimensions();
                    return;
                }
                entityNbt.putString("id", id);
                ValueInput in = TagValueInput.create((ProblemReporter)Walkers.PROBLEM_REPORTER, (HolderLookup.Provider)player.registryAccess(), (CompoundTag)entityNbt);
                Optional type = EntityType.by((ValueInput)in);
                if (type.isPresent()) {
                    LivingEntity shape = data.walkers$getCurrentShape();
                    if (shape == null || !((EntityType)type.get()).equals(shape.getType())) {
                        shape = (LivingEntity)((EntityType)type.get()).create(syncTarget.level(), EntitySpawnReason.LOAD);
                        data.walkers$setCurrentShape(shape);
                        syncTarget.refreshDimensions();
                    }
                    if (shape != null) {
                        shape.load(in);
                    }
                }
            }
        });
    }

    public static void handleAbilitySyncPacket(ModernNetworking.Context context, CompoundTag packet) {
        int cooldown = (Integer)packet.getInt("cooldown").orElseThrow();
        ClientNetworking.runOrQueue(context, player -> ((PlayerDataProvider)player).walkers$setAbilityCooldown(cooldown));
    }
}

