/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.network;

import dev.tocraft.craftedcore.event.common.PlayerEvents;
import dev.tocraft.craftedcore.network.ModernNetworking;
import dev.tocraft.walkers.api.PlayerAbilities;
import dev.tocraft.walkers.network.NetworkHandler;
import dev.tocraft.walkers.network.impl.SwapPackets;
import dev.tocraft.walkers.network.impl.SwapVariantPackets;
import dev.tocraft.walkers.network.impl.SyncApiLevelPackets;
import dev.tocraft.walkers.network.impl.UnlockPackets;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ServerNetworking
implements NetworkHandler {
    public static void initialize() {
        SwapPackets.registerWalkersRequestPacketHandler();
        UnlockPackets.registerShapeUnlockRequestPacketHandler();
        SwapVariantPackets.registerSwapVariantPacketHandler();
        ServerNetworking.registerUseAbilityPacketHandler();
        ModernNetworking.registerType((ResourceLocation)SHAPE_SYNC);
        ModernNetworking.registerType((ResourceLocation)ABILITY_SYNC);
        ModernNetworking.registerType((ResourceLocation)UNLOCK_SYNC);
        ModernNetworking.registerType((ResourceLocation)SYNC_API_LEVEL);
        PlayerEvents.PLAYER_JOIN.register(player -> {
            SyncApiLevelPackets.sendSyncPacket(player);
            UnlockPackets.sendSyncPacket(player);
        });
    }

    private static void registerUseAbilityPacketHandler() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (ResourceLocation)USE_ABILITY, (context, packet) -> {
            Player player = context.getPlayer();
            context.getPlayer().getServer().execute(() -> PlayerAbilities.useAbility((ServerPlayer)player));
        });
    }
}

