/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.network.impl;

import dev.tocraft.craftedcore.network.ModernNetworking;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.api.platform.ApiLevel;
import dev.tocraft.walkers.api.variant.ShapeType;
import dev.tocraft.walkers.impl.PlayerDataProvider;
import dev.tocraft.walkers.network.ClientNetworking;
import dev.tocraft.walkers.network.NetworkHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class SwapPackets {
    public static void registerWalkersRequestPacketHandler() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (ResourceLocation)NetworkHandler.SHAPE_REQUEST, (context, packet) -> context.getPlayer().getServer().execute(() -> {
            if (Walkers.isPlayerBlacklisted(context.getPlayer().getUUID()) && Walkers.CONFIG.blacklistPreventsMorphing) {
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"walkers.player_blacklisted"), true);
                return;
            }
            if (!ApiLevel.getCurrentLevel().canMorph) {
                return;
            }
            @Nullable ShapeType<?> type = null;
            if (PlayerShape.getCurrentShape(context.getPlayer()) == null) {
                type = ((PlayerDataProvider)context.getPlayer()).walkers$get2ndShape();
            }
            if (type != null) {
                PlayerShape.updateShapes((ServerPlayer)context.getPlayer(), type.create(context.getPlayer().level(), context.getPlayer()));
            } else {
                PlayerShape.updateShapes((ServerPlayer)context.getPlayer(), null);
            }
            context.getPlayer().refreshDimensions();
        }));
    }

    public static void sendSwapRequest() {
        if (!ApiLevel.getCurrentLevel().canMorph) {
            return;
        }
        ModernNetworking.sendToServer((ResourceLocation)ClientNetworking.SHAPE_REQUEST, (CompoundTag)new CompoundTag());
    }
}

