/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.network.impl;

import dev.tocraft.craftedcore.network.ModernNetworking;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.api.PlayerShapeChanger;
import dev.tocraft.walkers.api.platform.ApiLevel;
import dev.tocraft.walkers.api.variant.ShapeType;
import dev.tocraft.walkers.api.variant.TypeProvider;
import dev.tocraft.walkers.api.variant.TypeProviderRegistry;
import dev.tocraft.walkers.network.ClientNetworking;
import dev.tocraft.walkers.network.NetworkHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class SwapVariantPackets {
    public static void registerSwapVariantPacketHandler() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (ResourceLocation)NetworkHandler.VARIANT_REQUEST, (context, packet) -> {
            if (!ApiLevel.getCurrentLevel().allowVariantsMenu) {
                return;
            }
            int variantID = packet.getInt("variant_id").orElse(-1);
            context.getPlayer().getServer().execute(() -> {
                if (Walkers.CONFIG.unlockEveryVariant) {
                    LivingEntity shape;
                    ShapeType<LivingEntity> newShapeType;
                    int range;
                    ShapeType<LivingEntity> currentShapeType = ShapeType.from(PlayerShape.getCurrentShape(context.getPlayer()));
                    TypeProvider<LivingEntity> typeProvider = TypeProviderRegistry.getProvider(currentShapeType.getEntityType());
                    int n = range = typeProvider != null ? typeProvider.size(context.getPlayer().level()) : -1;
                    if (Walkers.hasSpecialShape(context.getPlayer().getUUID()) && EntityType.getKey(currentShapeType.getEntityType()).equals((Object)ResourceLocation.parse((String)"minecraft:wolf")) && variantID == range) {
                        CompoundTag nbt = new CompoundTag();
                        nbt.putBoolean("isSpecial", true);
                        nbt.putString("id", EntityType.getKey(currentShapeType.getEntityType()).toString());
                        Entity created = EntityType.loadEntityRecursive((CompoundTag)nbt, (Level)context.getPlayer().level(), (EntitySpawnReason)EntitySpawnReason.LOAD, it -> it);
                        PlayerShape.updateShapes((ServerPlayer)context.getPlayer(), (LivingEntity)created);
                    } else if (currentShapeType != null && (newShapeType = ShapeType.from(currentShapeType.getEntityType(), variantID)) != null && (PlayerShapeChanger.change2ndShape((ServerPlayer)context.getPlayer(), newShapeType) || !ApiLevel.getCurrentLevel().canUnlock) && (shape = newShapeType.create(context.getPlayer().level(), context.getPlayer())) != null) {
                        PlayerShape.updateShapes((ServerPlayer)context.getPlayer(), shape);
                    }
                }
            });
        });
    }

    public static void sendSwapRequest(int variantID) {
        if (Walkers.CONFIG.unlockEveryVariant) {
            if (!ApiLevel.getCurrentLevel().allowVariantsMenu) {
                return;
            }
            CompoundTag packet = new CompoundTag();
            packet.putInt("variant_id", variantID);
            ModernNetworking.sendToServer((ResourceLocation)ClientNetworking.VARIANT_REQUEST, (CompoundTag)packet);
        }
    }
}

