/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.network.impl;

import dev.tocraft.craftedcore.network.ModernNetworking;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.api.PlayerShapeChanger;
import dev.tocraft.walkers.api.blacklist.EntityBlacklist;
import dev.tocraft.walkers.api.platform.ApiLevel;
import dev.tocraft.walkers.api.variant.ShapeType;
import dev.tocraft.walkers.impl.PlayerDataProvider;
import dev.tocraft.walkers.network.ClientNetworking;
import dev.tocraft.walkers.network.NetworkHandler;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class UnlockPackets {
    private static final String UNLOCK_KEY = "UnlockedShape";

    public static void handleUnlockSyncPacket(ModernNetworking.Context context, CompoundTag nbt) {
        if (nbt != null && ApiLevel.getCurrentLevel().canUnlock) {
            CompoundTag idTag = nbt.getCompound(UNLOCK_KEY).orElse(new CompoundTag());
            ClientNetworking.runOrQueue(context, player -> {
                if (!idTag.isEmpty()) {
                    ((PlayerDataProvider)player).walkers$set2ndShape(ShapeType.from(idTag));
                }
            });
        }
    }

    public static void registerShapeUnlockRequestPacketHandler() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (ResourceLocation)NetworkHandler.UNLOCK_REQUEST, (context, nbt) -> {
            if (Walkers.isPlayerBlacklisted(context.getPlayer().getUUID()) && Walkers.CONFIG.blacklistPreventsUnlocking) {
                return;
            }
            if (!ApiLevel.getCurrentLevel().canUnlock) {
                return;
            }
            boolean validType = nbt.getBoolean("valid_type").orElse(false);
            if (validType) {
                ResourceLocation typeId = ResourceLocation.parse((String)((String)nbt.getString("type_id").orElseThrow()));
                EntityType entityType = (EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(typeId).orElseThrow()).value();
                int variant = nbt.getInt("variant").orElse(-1);
                context.getPlayer().getServer().execute(() -> {
                    boolean result;
                    @Nullable ShapeType<Z> type = ShapeType.from(entityType, variant);
                    if (type != null && !EntityBlacklist.isBlacklisted(type.getEntityType()) && (Walkers.CONFIG.unlockOverridesCurrentShape || ((PlayerDataProvider)context.getPlayer()).walkers$get2ndShape() == null) && (result = PlayerShapeChanger.change2ndShape((ServerPlayer)context.getPlayer(), type))) {
                        UnlockPackets.sendSyncPacket((ServerPlayer)context.getPlayer());
                        PlayerShape.updateShapes((ServerPlayer)context.getPlayer(), type.create(context.getPlayer().level(), context.getPlayer()));
                    }
                });
            } else {
                context.getPlayer().getServer().execute(() -> PlayerShape.updateShapes((ServerPlayer)context.getPlayer(), null));
            }
            context.getPlayer().refreshDimensions();
        });
    }

    public static void sendSyncPacket(ServerPlayer player) {
        CompoundTag compound = new CompoundTag();
        CompoundTag id = new CompoundTag();
        ShapeType<?> ndShape = ((PlayerDataProvider)player).walkers$get2ndShape();
        if (ndShape != null) {
            id = ndShape.writeCompound();
        }
        compound.put(UNLOCK_KEY, (Tag)id);
        ModernNetworking.sendToPlayer((ServerPlayer)player, (ResourceLocation)NetworkHandler.UNLOCK_SYNC, (CompoundTag)compound);
    }

    public static void sendUnlockRequest(@Nullable ShapeType<? extends LivingEntity> type) {
        CompoundTag packet = new CompoundTag();
        packet.putBoolean("valid_type", type != null);
        if (type != null) {
            packet.putString("type_id", EntityType.getKey(type.getEntityType()).toString());
            packet.putInt("variant", type.getVariantData());
        }
        ModernNetworking.sendToServer((ResourceLocation)ClientNetworking.UNLOCK_REQUEST, (CompoundTag)packet);
    }
}

