/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.screen.hud;

import dev.tocraft.craftedcore.event.client.RenderEvents;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.WalkersClient;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.api.variant.ShapeType;
import dev.tocraft.walkers.api.variant.TypeProvider;
import dev.tocraft.walkers.api.variant.TypeProviderRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class VariantMenu
implements RenderEvents.HUDRendering {
    private static final Map<ShapeType<?>, LivingEntity> renderEntities = new HashMap();
    private static final Map<ShapeType<?>, LivingEntity> renderSpecialEntities = new HashMap();

    @ApiStatus.Internal
    public static void clearEntities() {
        renderEntities.clear();
        renderSpecialEntities.clear();
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker delta) {
        ShapeType<LivingEntity> currentShapeType;
        ClientLevel level;
        Minecraft minecraft = Minecraft.getInstance();
        if (!minecraft.options.hideGui && WalkersClient.isRenderingVariantsMenu && Walkers.CONFIG.unlockEveryVariant && minecraft.screen == null && (level = minecraft.level) != null && minecraft.player != null && (currentShapeType = ShapeType.from(PlayerShape.getCurrentShape((Player)minecraft.player))) != null) {
            LivingEntity currentShape;
            int range;
            boolean hasSpecialVariant = Walkers.hasSpecialShape(minecraft.player.getUUID()) && EntityType.getKey(currentShapeType.getEntityType()).equals((Object)ResourceLocation.parse((String)"minecraft:wolf"));
            int currVariant = currentShapeType.getVariantData();
            TypeProvider<LivingEntity> typeProvider = TypeProviderRegistry.getProvider(currentShapeType.getEntityType());
            int n = range = typeProvider != null ? typeProvider.size((Level)minecraft.level) : -1;
            if (hasSpecialVariant && (currentShape = PlayerShape.getCurrentShape((Player)minecraft.player)) != null) {
                TagValueOutput out = TagValueOutput.createWithContext((ProblemReporter)Walkers.PROBLEM_REPORTER, (HolderLookup.Provider)level.registryAccess());
                currentShape.saveWithoutId((ValueOutput)out);
                CompoundTag nbt = out.buildResult();
                if (nbt.contains("isSpecial") && nbt.getBoolean("isSpecial").orElse(false).booleanValue()) {
                    currVariant = range;
                }
            }
            int x = minecraft.getWindow().getGuiScaledWidth() / 7;
            int y = minecraft.getWindow().getGuiScaledHeight() / 5;
            guiGraphics.fillGradient(x * 3, 5, x * 4, y + 5, -1072689136, -804253680);
            if (range > -1) {
                ShapeType<LivingEntity> thisShapeType;
                WalkersClient.variantOffset = Mth.clamp((int)WalkersClient.variantOffset, (int)(-currVariant - (hasSpecialVariant ? 1 : 0)), (int)(range - currVariant - (hasSpecialVariant ? 0 : 1)));
                int variant = currVariant + WalkersClient.variantOffset;
                LivingEntity entity = null;
                if (hasSpecialVariant && variant == range) {
                    entity = renderSpecialEntities.computeIfAbsent(currentShapeType, arg_0 -> VariantMenu.lambda$render$1((Level)level, arg_0));
                } else if ((variant > -1 || hasSpecialVariant && variant == -1) && (variant < range || variant == currVariant) && (thisShapeType = ShapeType.from(currentShapeType.getEntityType(), variant)) != null) {
                    entity = renderEntities.computeIfAbsent(thisShapeType, arg_0 -> VariantMenu.lambda$render$2((Level)level, minecraft, arg_0));
                }
                if (entity != null) {
                    int leftPos = (int)((float)x * 3.0f + (float)x / 2.0f);
                    int topPos = (int)((float)y * 0.75f);
                    int k = leftPos - 20;
                    int l = topPos - 30;
                    int m = leftPos + 20;
                    int n2 = topPos + 30;
                    InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (int)k, (int)l, (int)m, (int)n2, (float)((int)(25.0f / Math.max(entity.getBbHeight(), entity.getBbWidth()))), (Vector3f)new Vector3f(), (Quaternionf)new Quaternionf().rotationXYZ(0.43633232f, (float)Math.PI, (float)Math.PI), null, (LivingEntity)entity);
                }
            } else {
                LivingEntity entity = renderEntities.computeIfAbsent(currentShapeType, arg_0 -> VariantMenu.lambda$render$3((Level)level, minecraft, arg_0));
                if (entity != null) {
                    int leftPos = (int)((float)x * 3.0f + (float)x / 2.0f);
                    int topPos = (int)((float)y * 0.75f);
                    int k = leftPos - 20;
                    int l = topPos - 30;
                    int m = leftPos + 20;
                    int n3 = topPos + 30;
                    InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (int)k, (int)l, (int)m, (int)n3, (float)((int)(25.0f / Math.max(entity.getBbHeight(), entity.getBbWidth()))), (Vector3f)new Vector3f(), (Quaternionf)new Quaternionf().rotationXYZ(0.43633232f, (float)Math.PI, (float)Math.PI), null, (LivingEntity)entity);
                }
            }
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Walkers.id("textures/gui/focused.png"), x * 3, 5, 0.0f, 0.0f, x, y, x, y);
        }
    }

    private static /* synthetic */ LivingEntity lambda$render$3(Level level, Minecraft minecraft, ShapeType type) {
        return type.create(level, (Player)minecraft.player);
    }

    private static /* synthetic */ LivingEntity lambda$render$2(Level level, Minecraft minecraft, ShapeType type) {
        return type.create(level, (Player)minecraft.player);
    }

    private static /* synthetic */ LivingEntity lambda$render$1(Level level, ShapeType type) {
        CompoundTag nbt = new CompoundTag();
        nbt.putBoolean("isSpecial", true);
        nbt.putString("id", EntityType.getKey(type.getEntityType()).toString());
        return (LivingEntity)EntityType.loadEntityRecursive((CompoundTag)nbt, (Level)level, (EntitySpawnReason)EntitySpawnReason.LOAD, it -> it);
    }
}

