/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.traits;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.integrations.Integrations;
import dev.tocraft.walkers.traits.ShapeTrait;
import dev.tocraft.walkers.traits.impl.AquaticTrait;
import dev.tocraft.walkers.traits.impl.AttackForHealthTrait;
import dev.tocraft.walkers.traits.impl.BurnInDaylightTrait;
import dev.tocraft.walkers.traits.impl.CantFreezeTrait;
import dev.tocraft.walkers.traits.impl.CantInteractTrait;
import dev.tocraft.walkers.traits.impl.CantSwimTrait;
import dev.tocraft.walkers.traits.impl.ClimbBlocksTrait;
import dev.tocraft.walkers.traits.impl.FearedTrait;
import dev.tocraft.walkers.traits.impl.FlyingTrait;
import dev.tocraft.walkers.traits.impl.HumanoidTrait;
import dev.tocraft.walkers.traits.impl.ImmunityTrait;
import dev.tocraft.walkers.traits.impl.InstantDieOnDamageMsgTrait;
import dev.tocraft.walkers.traits.impl.InvulnerabilityTrait;
import dev.tocraft.walkers.traits.impl.MobEffectTrait;
import dev.tocraft.walkers.traits.impl.NoPhysicsTrait;
import dev.tocraft.walkers.traits.impl.NocturnalTrait;
import dev.tocraft.walkers.traits.impl.PreyTrait;
import dev.tocraft.walkers.traits.impl.ReinforcementsTrait;
import dev.tocraft.walkers.traits.impl.RiderTrait;
import dev.tocraft.walkers.traits.impl.SlowFallingTrait;
import dev.tocraft.walkers.traits.impl.StandOnFluidTrait;
import dev.tocraft.walkers.traits.impl.TemperatureTrait;
import dev.tocraft.walkers.traits.impl.UndrownableTrait;
import dev.tocraft.walkers.traits.impl.WalkOnPowderSnow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.HappyGhast;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraitRegistry {
    private static final Map<Predicate<LivingEntity>, List<ShapeTrait<?>>> traitsByPredicates = new ConcurrentHashMap();
    private static final Map<EntityType<? extends LivingEntity>, List<ShapeTrait<?>>> traitsByEntityTypes = new ConcurrentHashMap();
    private static final Map<TagKey<EntityType<?>>, List<ShapeTrait<?>>> traitsByEntityTags = new ConcurrentHashMap();
    private static final Map<Class<? extends LivingEntity>, List<ShapeTrait<?>>> traitsByEntityClasses = new ConcurrentHashMap();
    private static final Map<ResourceLocation, MapCodec<? extends ShapeTrait<?>>> traitCodecById = new HashMap();
    private static final Map<MapCodec<? extends ShapeTrait<?>>, ResourceLocation> traitIdByCodec = new IdentityHashMap();

    @ApiStatus.Internal
    public static void initialize() {
        TraitRegistry.registerCodec(MobEffectTrait.ID, MobEffectTrait.CODEC);
        TraitRegistry.registerCodec(BurnInDaylightTrait.ID, BurnInDaylightTrait.CODEC);
        TraitRegistry.registerCodec(FlyingTrait.ID, FlyingTrait.CODEC);
        TraitRegistry.registerCodec(PreyTrait.ID, PreyTrait.CODEC);
        TraitRegistry.registerCodec(TemperatureTrait.ID, TemperatureTrait.CODEC);
        TraitRegistry.registerCodec(RiderTrait.ID, RiderTrait.CODEC);
        TraitRegistry.registerCodec(StandOnFluidTrait.ID, StandOnFluidTrait.CODEC);
        TraitRegistry.registerCodec(NoPhysicsTrait.ID, NoPhysicsTrait.CODEC);
        TraitRegistry.registerCodec(CantSwimTrait.ID, CantSwimTrait.CODEC);
        TraitRegistry.registerCodec(UndrownableTrait.ID, UndrownableTrait.CODEC);
        TraitRegistry.registerCodec(SlowFallingTrait.ID, SlowFallingTrait.CODEC);
        TraitRegistry.registerCodec(FearedTrait.ID, FearedTrait.CODEC);
        TraitRegistry.registerCodec(ClimbBlocksTrait.ID, ClimbBlocksTrait.CODEC);
        TraitRegistry.registerCodec(ReinforcementsTrait.ID, ReinforcementsTrait.CODEC);
        TraitRegistry.registerCodec(InstantDieOnDamageMsgTrait.ID, InstantDieOnDamageMsgTrait.CODEC);
        TraitRegistry.registerCodec(AquaticTrait.ID, AquaticTrait.CODEC);
        TraitRegistry.registerCodec(WalkOnPowderSnow.ID, WalkOnPowderSnow.CODEC);
        TraitRegistry.registerCodec(HumanoidTrait.ID, HumanoidTrait.CODEC);
        TraitRegistry.registerCodec(AttackForHealthTrait.ID, AttackForHealthTrait.CODEC);
        TraitRegistry.registerCodec(NocturnalTrait.ID, NocturnalTrait.CODEC);
        TraitRegistry.registerCodec(CantInteractTrait.ID, CantInteractTrait.CODEC);
        TraitRegistry.registerCodec(ImmunityTrait.ID, ImmunityTrait.CODEC);
        TraitRegistry.registerCodec(CantFreezeTrait.ID, CantFreezeTrait.CODEC);
        TraitRegistry.registerCodec(InvulnerabilityTrait.ID, InvulnerabilityTrait.CODEC);
    }

    @ApiStatus.Internal
    public static void registerDefault() {
        TraitRegistry.registerByClass(Bat.class, new MobEffectTrait(new MobEffectInstance(MobEffects.NIGHT_VISION, 100000, 0, false, false)));
        TraitRegistry.registerByClass(Zombie.class, new BurnInDaylightTrait());
        TraitRegistry.registerByClass(Skeleton.class, new BurnInDaylightTrait());
        TraitRegistry.registerByClass(Stray.class, new BurnInDaylightTrait());
        TraitRegistry.registerByClass(Phantom.class, new BurnInDaylightTrait());
        TraitRegistry.registerByClass(Allay.class, new FlyingTrait());
        TraitRegistry.registerByClass(Allay.class, new MobEffectTrait(new MobEffectInstance(MobEffects.REGENERATION, 40, 2, false, false)));
        TraitRegistry.registerByClass(Allay.class, new AttackForHealthTrait());
        TraitRegistry.registerByClass(Bat.class, new FlyingTrait());
        TraitRegistry.registerByClass(Bee.class, new FlyingTrait());
        TraitRegistry.registerByClass(Blaze.class, new FlyingTrait());
        TraitRegistry.registerByClass(EnderDragon.class, new FlyingTrait());
        TraitRegistry.registerByPredicate((LivingEntity entity) -> entity instanceof FlyingAnimal, new FlyingTrait());
        TraitRegistry.registerByClass(Parrot.class, new FlyingTrait());
        TraitRegistry.registerByClass(Vex.class, new FlyingTrait());
        TraitRegistry.registerByClass(WitherBoss.class, new FlyingTrait());
        TraitRegistry.registerByClass(Ghast.class, new FlyingTrait());
        TraitRegistry.registerByClass(HappyGhast.class, new FlyingTrait());
        TraitRegistry.registerByClass(Phantom.class, new FlyingTrait());
        TraitRegistry.registerByClass(Bat.class, PreyTrait.ofHunterClass(Wolf.class));
        TraitRegistry.registerByClass(Fox.class, PreyTrait.ofHunterClass(Wolf.class));
        TraitRegistry.registerByClass(Sheep.class, PreyTrait.ofHunterClass(Wolf.class));
        TraitRegistry.registerByClass(Skeleton.class, PreyTrait.ofHunterClass(Wolf.class));
        TraitRegistry.registerByClass(Parrot.class, PreyTrait.ofHunterClass(Wolf.class));
        TraitRegistry.registerByClass(Rabbit.class, PreyTrait.ofHunterClass(Wolf.class));
        TraitRegistry.registerByClass(Chicken.class, PreyTrait.ofHunterClass(Fox.class));
        TraitRegistry.registerByClass(Rabbit.class, PreyTrait.ofHunterClass(Fox.class));
        TraitRegistry.registerByPredicate((LivingEntity entity) -> entity instanceof Turtle && entity.isBaby(), PreyTrait.ofHunterClass(Fox.class));
        TraitRegistry.registerByClass(Chicken.class, PreyTrait.ofHunterClass(Ocelot.class));
        TraitRegistry.registerByTag(EntityTypeTags.AXOLOTL_HUNT_TARGETS, PreyTrait.ofHunterClass(Axolotl.class));
        TraitRegistry.registerByTag(EntityTypeTags.AXOLOTL_ALWAYS_HOSTILES, PreyTrait.ofHunterClass(Axolotl.class));
        TraitRegistry.registerByPredicate((LivingEntity entity) -> entity instanceof Enemy && !(entity instanceof Creeper), new PreyTrait(List.of(), List.of(), List.of(IronGolem.class), List.of(), 3, 5));
        TraitRegistry.registerByClass(SnowGolem.class, new TemperatureTrait());
        TraitRegistry.registerByTag(EntityTypeTags.RAIDERS, RiderTrait.ofRideableClass(Ravager.class));
        TraitRegistry.registerByClass(Skeleton.class, RiderTrait.ofRideableClass(Spider.class));
        TraitRegistry.registerByPredicate((LivingEntity entity) -> entity instanceof Enemy, new RiderTrait(List.of(rideable -> rideable instanceof AbstractHorse && rideable instanceof Enemy)));
        TraitRegistry.registerByClass(Strider.class, new StandOnFluidTrait((TagKey<Fluid>)FluidTags.LAVA));
        TraitRegistry.registerByClass(Vex.class, new NoPhysicsTrait());
        TraitRegistry.registerByClass(IronGolem.class, new CantSwimTrait());
        TraitRegistry.registerByClass(IronGolem.class, new UndrownableTrait());
        TraitRegistry.registerByClass(Wolf.class, FearedTrait.ofFearfulClass(AbstractSkeleton.class));
        TraitRegistry.registerByPredicate((LivingEntity entity) -> entity instanceof Ocelot || entity instanceof Cat, FearedTrait.ofFearfulClass(Creeper.class));
        TraitRegistry.registerByClass(Ocelot.class, FearedTrait.ofFearfulClass(Chicken.class));
        TraitRegistry.registerByClass(Axolotl.class, FearedTrait.ofFearfulTag(EntityTypeTags.AXOLOTL_HUNT_TARGETS));
        TraitRegistry.registerByClass(Spider.class, new ClimbBlocksTrait());
        TraitRegistry.registerByClass(Spider.class, new ClimbBlocksTrait(List.of(Blocks.COBWEB), new ArrayList<Block>()));
        TraitRegistry.registerByClass(Wolf.class, new ReinforcementsTrait());
        TraitRegistry.registerByClass(Bee.class, new ReinforcementsTrait());
        TraitRegistry.registerByTag(EntityTypeTags.RAIDERS, new ReinforcementsTrait(32, new ArrayList(), List.of(EntityTypeTags.RAIDERS)));
        TraitRegistry.registerByClass(Turtle.class, new InstantDieOnDamageMsgTrait("lightningBolt"));
        TraitRegistry.registerByClass(Rabbit.class, new PreyTrait(List.of(entity -> {
            Cat cat;
            return entity instanceof Cat && !(cat = (Cat)entity).isTame();
        })));
        TraitRegistry.registerByPredicate((LivingEntity entity) -> entity.getType().getCategory().getName().contains("water") && entity.canBreatheUnderwater(), new AquaticTrait());
        TraitRegistry.registerByPredicate((LivingEntity entity) -> entity.getType().getCategory().getName().contains("water") != entity.canBreatheUnderwater(), new AquaticTrait(true, true));
        TraitRegistry.registerByClass(Dolphin.class, new AquaticTrait());
        TraitRegistry.registerByClass(Rabbit.class, new WalkOnPowderSnow());
        TraitRegistry.registerByTag(EntityTypeTags.POWDER_SNOW_WALKABLE_MOBS, new WalkOnPowderSnow());
        TraitRegistry.registerByClass(Chicken.class, new SlowFallingTrait());
        TraitRegistry.registerByTag(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Walkers.id("burns_in_daylight")), new BurnInDaylightTrait());
        TraitRegistry.registerByTag(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Walkers.id("flying")), new FlyingTrait(false));
        TraitRegistry.registerByTag(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Walkers.id("slow_falling")), new SlowFallingTrait());
        TraitRegistry.registerByTag(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Walkers.id("wolf_prey")), PreyTrait.ofHunterClass(Wolf.class));
        TraitRegistry.registerByTag(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Walkers.id("fox_prey")), PreyTrait.ofHunterClass(Fox.class));
        TraitRegistry.registerByTag(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Walkers.id("hurt_by_high_temperature")), new TemperatureTrait());
        TraitRegistry.registerByTag(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Walkers.id("ravager_riding")), RiderTrait.ofRideableClass(Ravager.class));
        TraitRegistry.registerByTag(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Walkers.id("lava_walking")), new StandOnFluidTrait((TagKey<Fluid>)FluidTags.LAVA));
        TraitRegistry.registerByTag(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Walkers.id("fall_through_blocks")), new NoPhysicsTrait());
        TraitRegistry.registerByTag(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Walkers.id("cant_swim")), new CantSwimTrait());
        TraitRegistry.registerByTag(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Walkers.id("undrownable")), new UndrownableTrait());
        TraitRegistry.registerByPredicate((LivingEntity entity) -> entity.getType().getCategory().equals((Object)MobCategory.MONSTER), new AttackForHealthTrait());
        TraitRegistry.registerByPredicate((LivingEntity entity) -> entity.getType().getCategory().equals((Object)MobCategory.MONSTER), new NocturnalTrait());
        TraitRegistry.registerByClass(Raider.class, new CantInteractTrait(List.of(Villager.class)));
        TraitRegistry.registerByClass(WitherBoss.class, new ImmunityTrait((MobEffect)MobEffects.WITHER.value()));
        TraitRegistry.registerByClass(WitherSkeleton.class, new ImmunityTrait((MobEffect)MobEffects.WITHER.value()));
        TraitRegistry.registerByClass(SnowGolem.class, new CantFreezeTrait());
        TraitRegistry.registerByClass(PolarBear.class, new CantFreezeTrait());
        TraitRegistry.registerByClass(Stray.class, new CantFreezeTrait());
        TraitRegistry.registerByClass(WitherBoss.class, new CantFreezeTrait());
        TraitRegistry.registerByTag(EntityTypeTags.FREEZE_IMMUNE_ENTITY_TYPES, new CantFreezeTrait());
        TraitRegistry.registerByType(EntityType.CREAKING, new InvulnerabilityTrait());
        Integrations.registerTraits();
    }

    @NotNull
    public static synchronized <L extends LivingEntity> List<ShapeTrait<L>> getAll(L shape) {
        ArrayList<ShapeTrait<L>> traits = new ArrayList<ShapeTrait<L>>();
        if (shape != null) {
            List<ShapeTrait<?>> list = traitsByEntityTypes.get(shape.getType());
            if (list != null) {
                traits.addAll(list.stream().map(trait -> trait).toList());
            }
            for (Map.Entry<Class<LivingEntity>, List<ShapeTrait<?>>> entry : traitsByEntityClasses.entrySet()) {
                if (!entry.getKey().isInstance(shape)) continue;
                traits.addAll(entry.getValue().stream().map(trait -> trait).toList());
            }
            for (Map.Entry<Class<LivingEntity>, List<ShapeTrait<?>>> entry : traitsByEntityTags.entrySet()) {
                if (!shape.getType().is((TagKey)entry.getKey())) continue;
                traits.addAll(entry.getValue().stream().map(trait -> trait).toList());
            }
            for (Map.Entry<Object, List<ShapeTrait<?>>> entry : traitsByPredicates.entrySet()) {
                if (!((Predicate)entry.getKey()).test(shape)) continue;
                traits.addAll(entry.getValue().stream().map(trait -> trait).toList());
            }
            return TraitRegistry.filterTraits(shape.getType(), traits);
        }
        return traits;
    }

    @NotNull
    public static synchronized <L extends LivingEntity> List<ShapeTrait<L>> get(L shape, ResourceLocation traitId) {
        List<ShapeTrait<L>> traits = TraitRegistry.getAll(shape);
        ArrayList<ShapeTrait<L>> filteredTraits = new ArrayList<ShapeTrait<L>>();
        for (ShapeTrait<L> trait : traits) {
            if (trait.getId() != traitId) continue;
            filteredTraits.add(trait);
        }
        return filteredTraits;
    }

    @ApiStatus.Experimental
    @NotNull
    public static synchronized Map<ShapeTrait<?>, Predicate<LivingEntity>> getAllRegisteredById(ResourceLocation traitId) {
        HashMap traits = new HashMap();
        for (Map.Entry<EntityType<LivingEntity>, List<ShapeTrait<?>>> entry : traitsByEntityTypes.entrySet()) {
            for (ShapeTrait<?> trait : entry.getValue()) {
                if (trait.getId() != traitId) continue;
                traits.put(trait, entity -> entity.getType().equals(traitList.getKey()) && TraitRegistry.notBlacklisted(entity.getType(), traitId));
            }
        }
        for (Map.Entry<Object, List<ShapeTrait<?>>> entry : traitsByEntityClasses.entrySet()) {
            for (ShapeTrait<?> trait : entry.getValue()) {
                if (trait.getId() != traitId) continue;
                traits.put(trait, entity -> ((Class)traitList.getKey()).isInstance(entity) && TraitRegistry.notBlacklisted(entity.getType(), traitId));
            }
        }
        for (Map.Entry<Object, List<ShapeTrait<?>>> entry : traitsByEntityTags.entrySet()) {
            for (ShapeTrait<?> trait : entry.getValue()) {
                if (trait.getId() != traitId) continue;
                traits.put(trait, entity -> entity.getType().is((TagKey)traitList.getKey()) && TraitRegistry.notBlacklisted(entity.getType(), traitId));
            }
        }
        for (Map.Entry<Object, List<ShapeTrait<?>>> entry : traitsByPredicates.entrySet()) {
            for (ShapeTrait<?> trait : entry.getValue()) {
                if (trait.getId() != traitId) continue;
                traits.put(trait, (Predicate)entry.getKey());
            }
        }
        return traits;
    }

    public static <A extends LivingEntity> void registerByType(EntityType<A> type, ShapeTrait<A> trait) {
        TraitRegistry.registerByType(type, List.of(trait));
    }

    public static <A extends LivingEntity> void registerByType(EntityType<A> type, @NotNull List<ShapeTrait<A>> newtraits) {
        List traits = traitsByEntityTypes.getOrDefault(type, new CopyOnWriteArrayList());
        for (ShapeTrait trait : newtraits) {
            if (!trait.canBeRegisteredMultipleTimes() && !traits.stream().noneMatch(entry -> entry.getId().equals((Object)trait.getId()))) continue;
            traits.add(trait);
        }
        traitsByEntityTypes.put(type, traits);
    }

    public static <A extends LivingEntity> void registerByTag(TagKey<EntityType<?>> tag, ShapeTrait<A> trait) {
        TraitRegistry.registerByTag(tag, List.of(trait));
    }

    public static <A extends LivingEntity> void registerByTag(TagKey<EntityType<?>> tag, @NotNull List<ShapeTrait<A>> newtraits) {
        List traits = traitsByEntityTags.getOrDefault(tag, new CopyOnWriteArrayList());
        for (ShapeTrait trait : newtraits) {
            if (!trait.canBeRegisteredMultipleTimes() && !traits.stream().noneMatch(entry -> entry.getId().equals((Object)trait.getId()))) continue;
            traits.add(trait);
        }
        traitsByEntityTags.put(tag, traits);
    }

    public static <A extends LivingEntity> void registerByClass(Class<A> entityClass, ShapeTrait<A> trait) {
        TraitRegistry.registerByClass(entityClass, List.of(trait));
    }

    public static <A extends LivingEntity> void registerByClass(Class<A> entityClass, @NotNull List<ShapeTrait<A>> newtraits) {
        List traits = traitsByEntityClasses.getOrDefault(entityClass, new CopyOnWriteArrayList());
        for (ShapeTrait trait : newtraits) {
            if (!trait.canBeRegisteredMultipleTimes() && !traits.stream().noneMatch(entry -> entry.getId().equals((Object)trait.getId()))) continue;
            traits.add(trait);
        }
        traitsByEntityClasses.put(entityClass, traits);
    }

    public static void registerByPredicate(Predicate<LivingEntity> entityPredicate, ShapeTrait<?> trait) {
        TraitRegistry.registerByPredicate(entityPredicate, List.of(trait));
    }

    public static void registerByPredicate(Predicate<LivingEntity> entityPredicate, @NotNull List<ShapeTrait<?>> newTraits) {
        List traits = traitsByPredicates.getOrDefault(entityPredicate, new CopyOnWriteArrayList());
        for (ShapeTrait<?> trait : newTraits) {
            if (!trait.canBeRegisteredMultipleTimes() && !traits.stream().noneMatch(entry -> entry.getId().equals((Object)trait.getId()))) continue;
            traits.add(trait);
        }
        traitsByPredicates.put(entityPredicate, traits);
    }

    public static void registerCodec(ResourceLocation traitId, MapCodec<? extends ShapeTrait<?>> traitCodec) {
        traitCodecById.put(traitId, traitCodec);
        traitIdByCodec.put(traitCodec, traitId);
    }

    @Nullable
    @ApiStatus.Internal
    public static MapCodec<? extends ShapeTrait<?>> getTraitCodec(ResourceLocation traitId) {
        return traitCodecById.get(traitId);
    }

    @Nullable
    @ApiStatus.Internal
    public static ResourceLocation getTraitId(MapCodec<? extends ShapeTrait<?>> traitCodec) {
        return traitIdByCodec.get(traitCodec);
    }

    public static <L extends LivingEntity> boolean has(L shape, ResourceLocation traitId) {
        if (shape != null) {
            List<ShapeTrait<?>> list = traitsByEntityTypes.get(shape.getType());
            if (list != null && list.stream().anyMatch(trait -> trait.getId() == traitId)) {
                return TraitRegistry.notBlacklisted(shape.getType(), traitId);
            }
            for (Map.Entry<Class<LivingEntity>, List<ShapeTrait<?>>> entry : traitsByEntityClasses.entrySet()) {
                if (!entry.getKey().isInstance(shape) || !entry.getValue().stream().anyMatch(trait -> trait.getId() == traitId)) continue;
                return TraitRegistry.notBlacklisted(shape.getType(), traitId);
            }
            for (Map.Entry<Class<LivingEntity>, List<ShapeTrait<?>>> entry : traitsByEntityTags.entrySet()) {
                if (!shape.getType().is((TagKey)entry.getKey()) || !entry.getValue().stream().anyMatch(trait -> trait.getId() == traitId)) continue;
                return TraitRegistry.notBlacklisted(shape.getType(), traitId);
            }
            for (Map.Entry<Object, List<ShapeTrait<?>>> entry : traitsByPredicates.entrySet()) {
                if (!((Predicate)entry.getKey()).test(shape) || !entry.getValue().stream().anyMatch(trait -> trait.getId() == traitId)) continue;
                return TraitRegistry.notBlacklisted(shape.getType(), traitId);
            }
        }
        return false;
    }

    @ApiStatus.Internal
    private static boolean notBlacklisted(EntityType<?> type, @NotNull ResourceLocation traitId) {
        return TraitRegistry.notBlacklisted(EntityType.getKey(type).toString(), traitId.toString());
    }

    private static boolean notBlacklisted(String type, String traitId) {
        return !Walkers.CONFIG.traitBlacklist.getOrDefault(type, List.of()).contains(traitId);
    }

    @ApiStatus.Internal
    @NotNull
    private static <L extends LivingEntity> List<ShapeTrait<L>> filterTraits(EntityType<?> type, @NotNull List<ShapeTrait<L>> traits) {
        ArrayList<ShapeTrait<L>> filtered = new ArrayList<ShapeTrait<L>>();
        String typeId = EntityType.getKey(type).toString();
        for (ShapeTrait<L> trait : traits) {
            if (!TraitRegistry.notBlacklisted(typeId, trait.getId().toString())) continue;
            filtered.add(trait);
        }
        return filtered;
    }

    @ApiStatus.Internal
    public static void clearAll() {
        traitsByEntityTypes.clear();
        traitsByEntityClasses.clear();
        traitsByEntityTags.clear();
        traitsByPredicates.clear();
    }

    @ApiStatus.Internal
    public static Codec<ShapeTrait<?>> getTraitCodec() {
        Codec codec = ResourceLocation.CODEC.flatXmap(resourceLocation -> Optional.ofNullable(TraitRegistry.getTraitCodec(resourceLocation)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown shape trait: " + String.valueOf(resourceLocation))), traitCodec -> Optional.ofNullable(TraitRegistry.getTraitId(traitCodec)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown shape trait codec: " + String.valueOf(traitCodec))));
        return codec.dispatchStable(ShapeTrait::codec, Function.identity());
    }
}

