/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.traits.impl;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.traits.ShapeTrait;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ClimbBlocksTrait<E extends LivingEntity>
extends ShapeTrait<E> {
    public static final ResourceLocation ID = Walkers.id("climb_blocks");
    public static final MapCodec<ClimbBlocksTrait<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("horizontal_collision", (Object)true).forGetter(o -> o.horizontalCollision), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("valid_blocks", new ArrayList()).forGetter(o -> o.validBlocks.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0)).toList()), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("invalid_blocks", new ArrayList()).forGetter(o -> o.invalidBlocks.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0)).toList())).apply((Applicative)instance, instance.stable((horizontalCollision, validBlocksLocation, invalidBlocksLocation) -> {
        ArrayList<Block> validBlocks = new ArrayList<Block>();
        for (ResourceLocation resourceLocation : validBlocksLocation) {
            if (!BuiltInRegistries.BLOCK.containsKey(resourceLocation)) continue;
            validBlocks.add((Block)((Holder.Reference)BuiltInRegistries.BLOCK.get(resourceLocation).orElseThrow()).value());
        }
        ArrayList<Block> invalidBlocks = new ArrayList<Block>();
        for (ResourceLocation resourceLocation : invalidBlocksLocation) {
            if (!BuiltInRegistries.BLOCK.containsKey(resourceLocation)) continue;
            validBlocks.add((Block)((Holder.Reference)BuiltInRegistries.BLOCK.get(resourceLocation).orElseThrow()).value());
        }
        return new ClimbBlocksTrait((boolean)horizontalCollision, (List<Block>)validBlocks, (List<Block>)invalidBlocks);
    })));
    public final boolean horizontalCollision;
    public final List<Block> validBlocks;
    public final List<Block> invalidBlocks;

    public ClimbBlocksTrait() {
        this(true);
    }

    public ClimbBlocksTrait(boolean horizontalCollision) {
        this(horizontalCollision, new ArrayList<Block>(), new ArrayList<Block>());
    }

    public ClimbBlocksTrait(List<Block> validBlocks, List<Block> invalidBlocks) {
        this(false, validBlocks, invalidBlocks);
    }

    public ClimbBlocksTrait(boolean horizontalCollision, List<Block> validBlocks, List<Block> invalidBlocks) {
        this.horizontalCollision = horizontalCollision;
        this.validBlocks = validBlocks;
        this.invalidBlocks = invalidBlocks;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends ShapeTrait<?>> codec() {
        return CODEC;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean renderIcon(RenderPipeline pipeline, @NotNull GuiGraphics graphics, int x, int y, int width, int height) {
        ItemStack stack = new ItemStack((ItemLike)Items.VINE);
        graphics.renderItem(stack, x, y);
        return true;
    }
}

