/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.traits.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.traits.ShapeTrait;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class FearedTrait<E extends LivingEntity>
extends ShapeTrait<E> {
    public static final ResourceLocation ID = Walkers.id("feared");
    public static final MapCodec<FearedTrait<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("fearful", new ArrayList()).forGetter(o -> o.fearfulTypes.stream().map(EntityType::getKey).toList()), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("fearful_tags", new ArrayList()).forGetter(o -> o.fearfulTags.stream().map(TagKey::location).toList())).apply((Applicative)instance, instance.stable((preyLocations, preyTagLocations) -> {
        ArrayList fearfulTypes = new ArrayList();
        ArrayList fearfulTags = new ArrayList();
        for (ResourceLocation resourceLocation : preyLocations) {
            if (!BuiltInRegistries.ENTITY_TYPE.containsKey(resourceLocation)) continue;
            fearfulTypes.add((EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(resourceLocation).orElseThrow()).value());
        }
        for (ResourceLocation preyTagLocation : preyTagLocations) {
            fearfulTags.add(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)preyTagLocation));
        }
        return new FearedTrait(new ArrayList<Predicate<LivingEntity>>(), fearfulTypes, new ArrayList<Class<? extends LivingEntity>>(), fearfulTags);
    })));
    private final List<Predicate<LivingEntity>> fearfulPredicates;
    private final List<EntityType<?>> fearfulTypes;
    private final List<Class<? extends LivingEntity>> fearfulClasses;
    private final List<TagKey<EntityType<?>>> fearfulTags;
    private final int priority;

    public static FearedTrait<?> ofFearfulType(EntityType<?> ... fearful) {
        return new FearedTrait(new ArrayList<Predicate<LivingEntity>>(), List.of(fearful), new ArrayList<Class<? extends LivingEntity>>(), new ArrayList());
    }

    @SafeVarargs
    public static FearedTrait<?> ofFearfulTag(TagKey<EntityType<?>> ... fearful) {
        return new FearedTrait(new ArrayList<Predicate<LivingEntity>>(), new ArrayList(), new ArrayList<Class<? extends LivingEntity>>(), List.of(fearful));
    }

    @SafeVarargs
    public static FearedTrait<?> ofFearfulClass(Class<? extends LivingEntity> ... fearful) {
        return new FearedTrait(new ArrayList<Predicate<LivingEntity>>(), new ArrayList(), List.of(fearful), new ArrayList());
    }

    public FearedTrait(@NotNull List<Predicate<LivingEntity>> fearfulPredicates) {
        this(fearfulPredicates, new ArrayList(), new ArrayList<Class<? extends LivingEntity>>(), new ArrayList());
    }

    public FearedTrait(@NotNull List<Predicate<LivingEntity>> fearfulPredicates, @NotNull List<EntityType<?>> fearfulTypes, @NotNull List<Class<? extends LivingEntity>> fearfulClasses, @NotNull List<TagKey<EntityType<?>>> fearfulTags) {
        this(fearfulPredicates, fearfulTypes, fearfulClasses, fearfulTags, 3);
    }

    public FearedTrait(@NotNull List<Predicate<LivingEntity>> fearfulPredicates, @NotNull List<EntityType<?>> fearfulTypes, @NotNull List<Class<? extends LivingEntity>> fearfulClasses, @NotNull List<TagKey<EntityType<?>>> fearfulTags, int priority) {
        this.fearfulPredicates = fearfulPredicates;
        this.fearfulTypes = fearfulTypes;
        this.fearfulClasses = fearfulClasses;
        this.fearfulTags = fearfulTags;
        this.priority = priority;
    }

    public boolean isFeared(LivingEntity entity) {
        if (this.fearfulTypes.contains(entity.getType())) {
            return true;
        }
        for (Class<? extends LivingEntity> clazz : this.fearfulClasses) {
            if (!clazz.isInstance(entity)) continue;
            return true;
        }
        for (TagKey tagKey : this.fearfulTags) {
            if (!entity.getType().is(tagKey)) continue;
            return true;
        }
        for (Predicate predicate : this.fearfulPredicates) {
            if (!predicate.test(entity)) continue;
            return true;
        }
        return false;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends ShapeTrait<?>> codec() {
        return CODEC;
    }
}

