/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.traits.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.traits.ShapeTrait;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class PreyTrait<E extends LivingEntity>
extends ShapeTrait<E> {
    public static final ResourceLocation ID = Walkers.id("prey");
    public static final MapCodec<PreyTrait<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("hunter", new ArrayList()).forGetter(o -> o.hunterTypes.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).getKey(arg_0)).toList()), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("hunter_tags", new ArrayList()).forGetter(o -> o.hunterTags.stream().map(TagKey::location).toList())).apply((Applicative)instance, instance.stable((hunterLocations, hunterTagLocations) -> {
        ArrayList hunterTypes = new ArrayList();
        ArrayList hunterTags = new ArrayList();
        for (ResourceLocation resourceLocation : hunterLocations) {
            if (!BuiltInRegistries.ENTITY_TYPE.containsKey(resourceLocation)) continue;
            hunterTypes.add((EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(resourceLocation).orElseThrow()).value());
        }
        for (ResourceLocation hunterTagLocation : hunterTagLocations) {
            hunterTags.add(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)hunterTagLocation));
        }
        return new PreyTrait(new ArrayList<Predicate<LivingEntity>>(), hunterTypes, new ArrayList<Class<? extends LivingEntity>>(), hunterTags);
    })));
    private final List<Predicate<LivingEntity>> hunterPredicates;
    private final List<EntityType<?>> hunterTypes;
    private final List<Class<? extends LivingEntity>> hunterClasses;
    private final List<TagKey<EntityType<?>>> hunterTags;
    private final int priority;
    private final int randInt;

    public static PreyTrait<?> ofHunterType(EntityType<?> ... hunter) {
        return new PreyTrait(new ArrayList<Predicate<LivingEntity>>(), List.of(hunter), new ArrayList<Class<? extends LivingEntity>>(), new ArrayList());
    }

    @SafeVarargs
    public static PreyTrait<?> ofHunterTag(TagKey<EntityType<?>> ... hunter) {
        return new PreyTrait(new ArrayList<Predicate<LivingEntity>>(), new ArrayList(), new ArrayList<Class<? extends LivingEntity>>(), List.of(hunter));
    }

    @SafeVarargs
    public static PreyTrait<?> ofHunterClass(Class<? extends LivingEntity> ... hunter) {
        return new PreyTrait(new ArrayList<Predicate<LivingEntity>>(), new ArrayList(), List.of(hunter), new ArrayList());
    }

    public PreyTrait(@NotNull List<Predicate<LivingEntity>> hunterPredicates) {
        this(hunterPredicates, new ArrayList(), new ArrayList<Class<? extends LivingEntity>>(), new ArrayList());
    }

    public PreyTrait(@NotNull List<Predicate<LivingEntity>> hunterPredicates, @NotNull List<EntityType<?>> hunterTypes, @NotNull List<Class<? extends LivingEntity>> hunterClasses, @NotNull List<TagKey<EntityType<?>>> hunterTags) {
        this(hunterPredicates, hunterTypes, hunterClasses, hunterTags, 7, 10);
    }

    public PreyTrait(@NotNull List<Predicate<LivingEntity>> hunterPredicates, @NotNull List<EntityType<?>> hunterTypes, @NotNull List<Class<? extends LivingEntity>> hunterClasses, @NotNull List<TagKey<EntityType<?>>> hunterTags, int priority, int randInt) {
        this.hunterPredicates = hunterPredicates;
        this.hunterTypes = hunterTypes;
        this.hunterClasses = hunterClasses;
        this.hunterTags = hunterTags;
        this.priority = priority;
        this.randInt = randInt;
    }

    public boolean isHunter(LivingEntity entity) {
        if (this.hunterTypes.contains(entity.getType())) {
            return true;
        }
        for (Class<? extends LivingEntity> clazz : this.hunterClasses) {
            if (!clazz.isInstance(entity)) continue;
            return true;
        }
        for (TagKey tagKey : this.hunterTags) {
            if (!entity.getType().is(tagKey)) continue;
            return true;
        }
        for (Predicate predicate : this.hunterPredicates) {
            if (!predicate.test(entity)) continue;
            return true;
        }
        return false;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getRandInt() {
        return this.randInt;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends ShapeTrait<?>> codec() {
        return CODEC;
    }
}

