/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.traits.impl;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.traits.ShapeTrait;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ReinforcementsTrait<E extends LivingEntity>
extends ShapeTrait<E> {
    public static final ResourceLocation ID = Walkers.id("reinforcements");
    public static final MapCodec<ReinforcementsTrait<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("range", (Object)32).forGetter(o -> o.range), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("reinforcements", new ArrayList()).forGetter(o -> o.reinforcementTypes.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).getKey(arg_0)).toList()), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("reinforcement_tags", new ArrayList()).forGetter(o -> o.reinforcementTags.stream().map(TagKey::location).toList())).apply((Applicative)instance, instance.stable((range, reinforcementsLocations, reinforcementTagsLocations) -> {
        ArrayList reinforcements = new ArrayList();
        ArrayList reinforcementTags = new ArrayList();
        for (ResourceLocation resourceLocation : reinforcementsLocations) {
            if (!BuiltInRegistries.ENTITY_TYPE.containsKey(resourceLocation)) continue;
            reinforcements.add((EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(resourceLocation).orElseThrow()).value());
        }
        for (ResourceLocation resourceLocation : reinforcementTagsLocations) {
            reinforcementTags.add(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)resourceLocation));
        }
        return new ReinforcementsTrait((int)range, reinforcements, reinforcementTags);
    })));
    private final int range;
    private final List<EntityType<?>> reinforcementTypes;
    private final List<TagKey<EntityType<?>>> reinforcementTags;

    public ReinforcementsTrait() {
        this(32);
    }

    public ReinforcementsTrait(int range) {
        this(range, new ArrayList());
    }

    public ReinforcementsTrait(List<EntityType<?>> reinforcementTypes) {
        this(32, reinforcementTypes);
    }

    public ReinforcementsTrait(int range, @NotNull List<EntityType<?>> reinforcementTypes) {
        this(range, reinforcementTypes, new ArrayList());
    }

    public ReinforcementsTrait(int range, @NotNull List<EntityType<?>> reinforcementTypes, @NotNull List<TagKey<EntityType<?>>> reinforcementTags) {
        this.range = range;
        this.reinforcementTypes = reinforcementTypes;
        this.reinforcementTags = reinforcementTags;
    }

    public boolean hasReinforcements() {
        return !this.reinforcementTypes.isEmpty() || !this.reinforcementTags.isEmpty();
    }

    public boolean isReinforcement(Entity entity) {
        if (this.reinforcementTypes.contains(entity.getType())) {
            return true;
        }
        for (TagKey<EntityType<?>> reinforcementTag : this.reinforcementTags) {
            if (!entity.getType().is(reinforcementTag)) continue;
            return true;
        }
        return false;
    }

    public int getRange() {
        return this.range;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends ShapeTrait<?>> codec() {
        return CODEC;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean renderIcon(RenderPipeline pipeline, @NotNull GuiGraphics graphics, int x, int y, int width, int height) {
        ItemStack stack = new ItemStack((ItemLike)Items.IRON_SWORD);
        graphics.renderItem(stack, x, y);
        return true;
    }
}

