/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.data.variants;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.data.SynchronizedJsonReloadListener;
import tocraft.craftedcore.platform.PlatformData;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.data.variants.NBTTypeProvider;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.api.variant.TypeProviderRegistry;

public class TypeProviderDataManager
extends SynchronizedJsonReloadListener {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).create();
    public static Codec<Either<TypeProviderEntry<?>, String>> TYPE_PROVIDER_LIST_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("entity_type").forGetter(o -> ((TypeProviderEntry)o.left().orElseThrow()).entityTypeKey()), (App)Codec.STRING.optionalFieldOf("required_mod", (Object)"").forGetter(o -> {
        String requiredMod = ((TypeProviderEntry)o.left().orElseThrow()).requiredMod();
        if (requiredMod == null) {
            return "";
        }
        return requiredMod;
    }), (App)class_2960.field_25139.optionalFieldOf("parent").forGetter(o -> {
        for (Pair<class_1299<? extends class_1309>, TypeProvider<?>> pair : TypeProviderRegistry.getAll()) {
            if (pair.getSecond() != ((TypeProviderEntry)o.left().orElseThrow()).typeProvider()) continue;
            return Optional.of(class_1299.method_5890((class_1299)((class_1299)pair.getFirst())));
        }
        return Optional.empty();
    }), (App)Codec.STRING.optionalFieldOf("type_provider_class").forGetter(o -> {
        if (((TypeProviderEntry)o.left().orElseThrow()).typeProvider() instanceof NBTTypeProvider) {
            return Optional.empty();
        }
        return Optional.of(((TypeProviderEntry)o.left().orElseThrow()).typeProvider().getClass().getName());
    }), (App)NBTTypeProvider.CODEC.optionalFieldOf("type_provider").forGetter(o -> {
        TypeProvider patt0$temp = ((TypeProviderEntry)o.left().orElseThrow()).typeProvider();
        if (patt0$temp instanceof NBTTypeProvider) {
            NBTTypeProvider nbtTypeProvider = (NBTTypeProvider)patt0$temp;
            return Optional.of(nbtTypeProvider);
        }
        return Optional.empty();
    })).apply((Applicative)instance, instance.stable((entityType, requiredMod, parent, typeProviderClassOptional, typeProviderOptional) -> {
        TypeProvider typeProvider;
        if (typeProviderOptional.isPresent()) {
            typeProvider = (TypeProvider)typeProviderOptional.get();
        } else if (parent.isPresent()) {
            typeProvider = TypeProviderRegistry.getProvider((class_1299)Walkers.getEntityTypeRegistry().method_10223((class_2960)parent.get()));
        } else if (typeProviderClassOptional.isPresent()) {
            try {
                typeProvider = Class.forName((String)typeProviderClassOptional.get()).asSubclass(TypeProvider.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return Either.right((Object)(TypeProviderDataManager.class.getSimpleName() + ": No valid type provider class registered in %s"));
            }
        } else {
            return Either.right((Object)(TypeProviderDataManager.class.getSimpleName() + ": No valid type provider registered in %s"));
        }
        if (typeProvider != null) {
            return Either.left(new TypeProviderEntry((class_2960)entityType, (String)requiredMod, typeProvider));
        }
        return Either.right((Object)(TypeProviderDataManager.class.getSimpleName() + ": Error while loading %s"));
    })));

    public TypeProviderDataManager() {
        super(GSON, "walkers/variants");
    }

    protected void onApply(Map<class_2960, JsonElement> map) {
        TypeProviderRegistry.clearAll();
        TypeProviderRegistry.registerDefault();
        for (Map.Entry<class_2960, JsonElement> mapEntry : map.entrySet()) {
            TypeProviderEntry typeProviderEntry;
            class_1299 entityType;
            Either<TypeProviderEntry<?>, String> typeProviderEntryStringEither = TypeProviderDataManager.typeProviderFromJson(mapEntry.getValue().getAsJsonObject());
            if (typeProviderEntryStringEither.right().isPresent()) {
                Walkers.LOGGER.warn(String.format((String)typeProviderEntryStringEither.right().get(), mapEntry.getKey()));
                continue;
            }
            if (!typeProviderEntryStringEither.left().isPresent() || (entityType = (typeProviderEntry = (TypeProviderEntry)typeProviderEntryStringEither.left().get()).entityType()) == null) continue;
            TypeProviderRegistry.register(entityType, typeProviderEntry.typeProvider());
            Walkers.LOGGER.info("{}: {} registered for {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), typeProviderEntry.entityTypeKey(), typeProviderEntry.typeProvider().getClass()});
        }
    }

    private static Either<TypeProviderEntry<?>, String> typeProviderFromJson(JsonObject json) {
        return (Either)TYPE_PROVIDER_LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, msg -> {
            throw new JsonParseException(msg);
        });
    }

    public record TypeProviderEntry<L extends class_1309>(class_2960 entityTypeKey, @Nullable String requiredMod, TypeProvider<L> typeProvider) {
        public TypeProviderEntry(class_1299<L> entityType, String requiredMod, TypeProvider<L> typeProvider) {
            this(class_1299.method_5890(entityType), requiredMod, typeProvider);
        }

        @Nullable
        public class_1299<L> entityType() {
            if ((this.requiredMod() == null || this.requiredMod().isBlank() || PlatformData.isModLoaded((String)this.requiredMod())) && Walkers.getEntityTypeRegistry().method_10250(this.entityTypeKey())) {
                return (class_1299)Walkers.getEntityTypeRegistry().method_10223(this.entityTypeKey());
            }
            return null;
        }
    }
}

