/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.model;

import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1453;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.api.model.EntityUpdater;
import tocraft.walkers.api.model.impl.AbstractHorseEntityUpdater;
import tocraft.walkers.api.model.impl.ShulkerEntityUpdater;
import tocraft.walkers.api.model.impl.SquidEntityUpdater;
import tocraft.walkers.impl.NearbySongAccessor;
import tocraft.walkers.mixin.accessor.CreeperEntityAccessor;
import tocraft.walkers.mixin.accessor.ParrotEntityAccessor;

@Environment(value=EnvType.CLIENT)
public class EntityUpdaters {
    private static final Map<class_1299<? extends class_1309>, EntityUpdater<? extends class_1309>> map = new LinkedHashMap<class_1299<? extends class_1309>, EntityUpdater<? extends class_1309>>();

    public static <T extends class_1309> EntityUpdater<T> getUpdater(class_1299<T> entityType) {
        return map.getOrDefault(entityType, null);
    }

    public static <T extends class_1309> void register(class_1299<T> type, EntityUpdater<T> entityUpdater) {
        map.put(type, entityUpdater);
    }

    public static void init() {
        EntityUpdaters.register(class_1299.field_6139, new AbstractHorseEntityUpdater());
        EntityUpdaters.register(class_1299.field_6067, new AbstractHorseEntityUpdater());
        EntityUpdaters.register(class_1299.field_6057, new AbstractHorseEntityUpdater());
        EntityUpdaters.register(class_1299.field_6108, (player, bat) -> bat.method_6449(!CEntity.level((class_1297)player).method_8320(player.method_24515().method_10084()).method_26215()));
        EntityUpdaters.register(class_1299.field_6104, (player, parrot) -> {
            parrot.method_6006(player.method_24515(), ((NearbySongAccessor)player).shape_isNearbySongPlaying());
            ((ParrotEntityAccessor)parrot).callCalculateFlapping();
            if (player.method_6051().nextInt(400) == 0) {
                class_1453.method_6587((class_1937)CEntity.level((class_1297)player), (class_1297)player);
            }
        });
        EntityUpdaters.register(class_1299.field_6116, (player, dragon) -> {
            dragon.field_7030 += 0.01f;
            dragon.field_7019 = dragon.field_7030;
            if (dragon.field_7010 < 0) {
                for (int l = 0; l < dragon.field_7026.length; ++l) {
                    dragon.field_7026[l][0] = (double)player.method_36454() + 180.0;
                    dragon.field_7026[l][1] = player.method_23318();
                }
            }
            if (++dragon.field_7010 == dragon.field_7026.length) {
                dragon.field_7010 = 0;
            }
            dragon.field_7026[dragon.field_7010][0] = (double)player.method_36454() + 180.0;
            dragon.field_7026[dragon.field_7010][1] = player.method_23318();
        });
        EntityUpdaters.register(class_1299.field_6091, (player, enderman) -> {
            class_1799 heldStack = player.method_6047();
            if (heldStack.method_7909() instanceof class_1747) {
                enderman.method_7032(((class_1747)heldStack.method_7909()).method_7711().method_9564());
            }
        });
        EntityUpdaters.register(class_1299.field_6046, (player, creeper) -> ((CreeperEntityAccessor)creeper).setSwell(0));
        EntityUpdaters.register(class_1299.field_6114, new SquidEntityUpdater());
        EntityUpdaters.register(class_1299.field_28402, new SquidEntityUpdater());
        EntityUpdaters.register(class_1299.field_6109, new ShulkerEntityUpdater());
        EntityUpdaters.register(class_1299.field_6132, (player, chicken) -> {
            chicken.field_6736 = chicken.field_6741;
            chicken.field_6738 = chicken.field_6743;
            chicken.field_6743 = chicken.field_6743 + (CEntity.isOnGround((class_1297)player) ? -1.0f : 4.0f) * 0.3f;
            chicken.field_6743 = class_3532.method_15363((float)chicken.field_6743, (float)0.0f, (float)1.0f);
            if (!CEntity.isOnGround((class_1297)player) && chicken.field_6737 < 1.0f) {
                chicken.field_6737 = 1.0f;
            }
            chicken.field_6737 *= 0.9f;
            chicken.field_6741 += chicken.field_6737 * 2.0f;
        });
        EntityUpdaters.register(class_1299.field_23214, (player, strider) -> {
            class_2680 blockState = CEntity.level((class_1297)player).method_8320(player.method_24515());
            boolean bl = blockState.method_26164(class_3481.field_23209) || player.method_5861(class_3486.field_15518) > 0.0;
            strider.method_26349(!bl);
        });
        EntityUpdaters.register(class_1299.field_16281, (player, cat) -> cat.method_6179(false));
    }
}

