/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.eventhandler;

import com.mojang.serialization.DynamicOps;
import net.minecraft.class_1267;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1496;
import net.minecraft.class_1588;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import tocraft.craftedcore.event.common.EntityEvents;
import tocraft.craftedcore.event.common.PlayerEvents;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.FlightHelper;
import tocraft.walkers.api.PlayerHostility;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.CantInteractTrait;
import tocraft.walkers.traits.impl.NocturnalTrait;
import tocraft.walkers.traits.impl.RiderTrait;

public class WalkersEventHandlers {
    public static void initialize() {
        WalkersEventHandlers.registerHostilityUpdateHandler();
        WalkersEventHandlers.registerEntityRidingHandler();
        WalkersEventHandlers.registerPlayerRidingHandler();
        WalkersEventHandlers.registerLivingDeathHandler();
        EntityEvents.INTERACT_WITH_PLAYER.register((player, entity, hand) -> {
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (shape != null) {
                for (ShapeTrait<class_1309> skill : TraitRegistry.get(shape, CantInteractTrait.ID)) {
                    if (((CantInteractTrait)skill).canInteractWithEntity(entity)) continue;
                    return class_1269.field_5814;
                }
            }
            return class_1269.field_5811;
        });
        PlayerEvents.ALLOW_SLEEP_TIME.register((player, sleepingPos, vanillaResult) -> {
            if (TraitRegistry.has(PlayerShape.getCurrentShape(player), NocturnalTrait.ID)) {
                return CEntity.level((class_1297)player).method_8530() ? class_1269.field_5812 : class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        PlayerEvents.SLEEP_FINISHED_TIME.register((level, newTime) -> {
            if (level.method_8530() && !level.method_18766(player -> player.method_6113() && TraitRegistry.has(PlayerShape.getCurrentShape((class_1657)player), NocturnalTrait.ID)).isEmpty()) {
                return newTime + level.method_8532() % 24000L > 12000L ? 13000L : -11000L;
            }
            return newTime;
        });
        PlayerEvents.AWARD_ADVANCEMENT.register((player, advancement, criterionKey) -> {
            if (Walkers.hasFlyingPermissions(player)) {
                FlightHelper.grantFlightTo(player);
                FlightHelper.updateFlyingSpeed((class_1657)player);
                player.method_7355();
            }
        });
    }

    public static void registerHostilityUpdateHandler() {
        EntityEvents.INTERACT_WITH_PLAYER.register((player, entity, hand) -> {
            if (!CEntity.level((class_1297)player).field_9236 && Walkers.CONFIG.playerCanTriggerHostiles && entity instanceof class_1588) {
                PlayerHostility.set(player, Walkers.CONFIG.hostilityTime);
            }
            return class_1269.field_5811;
        });
    }

    public static void registerEntityRidingHandler() {
        EntityEvents.INTERACT_WITH_PLAYER.register((player, entity, hand) -> {
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (shape != null && entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                for (RiderTrait riderTrait : TraitRegistry.get(shape, RiderTrait.ID).stream().map(entry -> (RiderTrait)entry).toList()) {
                    class_1657 rideablePlayer;
                    if (!riderTrait.isRideable(livingEntity) && (!(livingEntity instanceof class_1657) || !riderTrait.isRideable(PlayerShape.getCurrentShape(rideablePlayer = (class_1657)livingEntity)))) continue;
                    player.method_5804(entity);
                    return class_1269.field_5811;
                }
            }
            return class_1269.field_5811;
        });
    }

    public static void registerPlayerRidingHandler() {
        EntityEvents.INTERACT_WITH_PLAYER.register((player, entity, hand) -> {
            class_1657 playerToBeRidden;
            if (entity instanceof class_1657 && PlayerShape.getCurrentShape(playerToBeRidden = (class_1657)entity) instanceof class_1496) {
                player.method_5873((class_1297)playerToBeRidden, true);
            }
            return class_1269.field_5811;
        });
    }

    public static void registerLivingDeathHandler() {
        EntityEvents.LIVING_DEATH.register((entity, damageSource) -> {
            if (!CEntity.level((class_1297)entity).method_8608() && entity instanceof class_1646) {
                class_1641 zombievillager;
                class_1657 player;
                class_1646 villager = (class_1646)entity;
                class_1297 patt0$temp = damageSource.method_5529();
                if (patt0$temp instanceof class_1657 && PlayerShape.getCurrentShape(player = (class_1657)patt0$temp) instanceof class_1642 && (CEntity.level((class_1297)player).method_8407() == class_1267.field_5807 || !player.method_6051().nextBoolean()) && (zombievillager = (class_1641)villager.method_29243(class_1299.field_6054, false)) != null) {
                    zombievillager.method_5943((class_5425)CEntity.level((class_1297)player), CEntity.level((class_1297)player).method_8404(zombievillager.method_24515()), class_3730.field_16468, (class_1315)new class_1642.class_1644(false, true), null);
                    zombievillager.method_16916(villager.method_8264().method_8268());
                    zombievillager.method_7195(villager.method_7231());
                    zombievillager.method_21649((class_2520)villager.method_21651().method_19067((DynamicOps)class_2509.field_11560).getValue());
                    zombievillager.method_19622(villager.method_19269());
                }
            }
            return class_1269.field_5811;
        });
    }
}

